'use strict'
const View = use('View');
const edge = require('edge.js');
const Helpers = use('Helpers');
const __ = use('App/Class/Fa');
class Form{
    constructor(model){
        this.fileds=[];
        this.html = 'html';
        this.model=model;
        this.record=null;
        this.title='ایجاد';
        return this;
    }

    async edit(id){
      
        var list= await this.model.find(id);
        this.record=list;
        this.title='ویرایش';

        return this;
    }

    text(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'text'});
        return this;
    }


    persiandate(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'persiandate'});
        return this;
    }

    editor(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'texteditor'});
        return this;
    }


    


    

    textarea(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'textarea'});
        return this;
    }

    time(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'time'});
        return this;
    }


    image(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'image'});
        return this;
    }

    file(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'file'});
        return this;
    }


    map(caption){
        this.fileds.push({
            name:'map',
            title:caption,
            type:'map'
        })

        return this;
    }


    polygonmap(caption){
        this.fileds.push({
            name:'polygonmap',
            title:caption,
            type:'polygonmap'
        })
    }


    

    email(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'email'});
        return this;
    }

    icon(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'icon'});
        return this;
    }

    select(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'select',options:[]});
        return this;
    }

    options(myarray){
        var filed=this.fileds[this.fileds.length - 1];
        filed.options=myarray;
        this.fileds[this.fileds.length - 1]=filed;
        return this;
    }


    accept(accept){
        var filed=this.fileds[this.fileds.length - 1];
        filed.accept=accept;
        this.fileds[this.fileds.length - 1]=filed;
        return this;
    }

    
    number(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'number'});
        return this;
    }

    password(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'password'});
        return this;
    }

    onepassword(filed,caption){
        this.fileds.push({name:filed,title:caption,type:'onepassword'});
        return this;
    }







    async render(){
        var list= [];


        // return JSON.stringify( this.record );

        
        edge.configure({
            cache:  false
          })
          edge.registerViews(Helpers.viewsPath())
          edge.registerPresenters(Helpers.resourcesPath('presenters'))
          this.engine = edge

          this.html= this.engine.render('admin.layouts.form',{__:__,title:this.title,fileds:this.fileds,model:this.model,list:list,record:this.record,keys:Object.keys(this.fileds)})

    
        return this.html;


    }
}

module.exports = Form;