'use strict'

const { Command } = require('@adonisjs/ace')
const fs = require('fs');
const { env } = require('process');
const Env = use('Env');
const mysql = require('mysql2/promise');
var pluralize = require('pluralize');
const toSnakeCase = require('js-snakecase');




class AdminMake extends Command {
  static get signature () {
    return 'mahjava:make {name:controller name}'
  }

  static get description () {
    return 'Tell something helpful about this command'
  }


  async generate(args,model,type,title) {

    var con = await  mysql.createConnection({
      host: Env.get('DB_HOST'),
      user:  Env.get('DB_USER'),
      password: Env.get('DB_PASSWORD'),
      database:Env.get('DB_DATABASE')
    });


    const [rows, fields] = await con.execute("SHOW COLUMNS FROM "+toSnakeCase(pluralize(model)));


    var grid='';
    var form='';


    rows.forEach(element => {
      if(element.Field!='id' && element.Field!='created_at' && element.Field!='updated_at' && element.Field!='uuid'){
        grid=grid+"        grid.column('"+element.Field+"', __('"+element.Field+"'));\r\n";
        form=form+"        form.text('"+element.Field+"', __('"+element.Field+"'));\r\n";
       
      }
     
    });


    var gridend='';

    if(type=='just list'){
      gridend="\r\n        grid.disableCreation();\r\n        grid.disableDelete();\r\n        grid.disableEdit();\r\n";
    }
    if(type=='not creatable'){
      gridend="\r\n        grid.disableCreation();\r\n";
    }

    // console.log(grid)

    //console.log(rows);


    var path=__dirname+'\\..\\Controllers\\Http\\Admin\\'+args.name+'.js'

    var modelpath=__dirname+'\\..\\Models\\'+model+'.js';

    
  


   

 


    //SHOW COLUMNS FROM users


    

    if(fs.existsSync(path)){
      this.error('exist controller');
      process.exit();
    }


    if(!fs.existsSync(modelpath)){
      this.error('not exist model '+model);
      process.exit();
    }


    await fs.writeFileSync(path,`
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const `+model+` = use('App/Models/`+model+`');
const __ = use('App/Class/Fa');
class `+args.name+` extends AdminController {    

      constructor(){
        super();
        this.title="`+title+`";
      }


      async grid({request ,view}){
        var grid=  new Grid(`+model+`,request.originalUrl()); 
        grid.column('id', __('Id'));
        `+grid+`
        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(`+model+`);
        if (id != null) {
            await form.edit(id);
        }
        `+form+`
        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await `+model+`.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async store({ request, view, session }) {

        try {
            var record = await `+model+`.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.index({ request, view, session });
      }


      async remove({ request, view, session, params }) {

            try {
                var record = await `+model+`.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session });

      }



}

module.exports = `+args.name+`



`);


    var route=args.name;
    route=route.replace('Controller','');
    route=toSnakeCase(pluralize(route));


    console.log("\r\n");
    console.log("\r\n");


    console.log(`
    Route.get('/`+route+`','Admin/`+args.name+`.index');
    Route.get('/`+route+`/create','Admin/`+args.name+`.create');
    Route.post('/`+route+`/create','Admin/`+args.name+`.store');
    Route.get('/`+route+`/edit/:id','Admin/`+args.name+`.show');
    Route.post('/`+route+`/edit/:id','Admin/`+args.name+`.update');
    Route.get('/`+route+`/remove/:id','Admin/`+args.name+`.remove');
    `)

    console.log("\r\n");
    console.log("\r\n");


    console.log(` AdminMenu.query().insert({
      parent_id:0,
      order:0,
      title:'`+title+`',
      icon:'fa fa-th',
      uri:'/`+route+`'
    })`)

    console.log("\r\n");
    console.log("\r\n");



    
    return true;
  }

  async handle (args, options) {

    const model = await this
    .ask('Enter model for controller:')


    const title = await this
    .ask('Enter title gird:')



    const type = await this
    .choice('type', [
      'normal',
      'just list',
      'not creatable'
    ])

   
    // console.log(options)
    var check=await this.generate(args,model,type,title);

    
    if(check){
      this.success('Ok')
    }else{
      this.error('Could not create')
    }
    process.exit();

    
  }
}

module.exports = AdminMake
