
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const AdminPermission = use('App/Models/AdminPermission');
const __ = use('App/Class/Fa');
class AdminPermissionController extends AdminController {    

      constructor(){
        super();
        this.title="دسترسی";
      }


      async grid({request ,view}){
        var grid=  new Grid(AdminPermission,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('name', __('name'));
        grid.column('slug', __('slug'));
        grid.column('http_method', __('http_method'));
        grid.column('http_path', __('http_path'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(AdminPermission);
        if (id != null) {
            await form.edit(id);
        }
                form.text('name', __('name'));
        form.text('slug', __('slug'));
        form.select('http_method', __('http_method')).options([{id:'GET',title:'GET'},{id:'Post',title:'Post'},{id:'Delete',title:'Delete'},{id:'any',title:'any'}]);
        form.textarea('http_path', __('http_path'));

        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await AdminPermission.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async store({ request, view, session,response }) {

        try {
            var record = await AdminPermission.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await AdminPermission.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = AdminPermissionController



