
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const AdminRoleMenu = use('App/Models/AdminRoleMenu');
const __ = use('App/Class/Fa');
const AdminRole = use('App/Models/AdminRole');
const AdminMenu = use('App/Models/admin/Menu');
class AdminRoleMenuController extends AdminController {    

      constructor(){
        super();
        this.title="چارچوب - منو";
      }


      async grid({request ,view}){
        var grid=  new Grid(AdminRoleMenu,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('menu_id', __('menu_id'));
        grid.column('role_id', __('role_id'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(AdminRoleMenu);
        if (id != null) {
            await form.edit(id);
        }

        var roles = await AdminRole.query().fetch();

        roles=roles.toJSON();

        var listroles=[];

        roles.forEach(function (e) {
          listroles.push({ id: e.id, title: e.slug });
        })

        var menus = await AdminMenu.query().fetch();

        menus=menus.toJSON();

        var listmenus=[];

        menus.forEach(function (e) {
          listmenus.push({ id: e.id, title: e.title });
        })

        form.select('menu_id', __('menu_id')).options(listmenus);
        form.select('role_id', __('role_id')).options(listroles);

        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await AdminRoleMenu.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async store({ request, view, session,response }) {

        try {
            var record = await AdminRoleMenu.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await AdminRoleMenu.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = AdminRoleMenuController



