'use strict'


const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid = use('App/Class/Grid');
const Form = use('App/Class/Form');
const AdminUser = use('App/Models/admin/User');
const __ = use('App/Class/Fa');


class AdminUserController extends AdminController {

    constructor() {
        super();
        this.title = "مدیریت مدیران";

    }

    async grid({ request, view }) {

        var grid = new Grid(AdminUser, request.originalUrl());

        grid.column('id', __('Id'));
        grid.column('username', __('Username'));
        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        grid.disableCreation();


        return grid.render();
    }


    async form({ request, view }, id = null) {
        var form = new Form(AdminUser);
        if (id != null) {
            await form.edit(id);
        }

        form.text('username', 'Username');
        form.password('Password', 'Password');



        return form.render();
    }


    async update({ request, view, params, session }) {

        try {
            var record = await AdminUser.query().where('id', '=', params.id).update({ username: request.input('username'), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }



        return this.show({ request, view, params, session });

    }


    async store({ request, view, session,response }) {

        try {
            var record = await AdminUser.query().insert({ username: request.input('username'), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return response.redirect(request.originalUrl().replace('/create', ''));
    }


    async remove({ request, view, session, params ,response }) {

        try {
            var record = await AdminUser.query().where('id', '=', params.id).delete();
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.index({ request, view, session,response});

    }

}

module.exports = AdminUserController