
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const Laboratory = use('App/Models/Laboratory');
const Therapist = use('App/Models/Therapist');
const __ = use('App/Class/Fa');
const Helpers = use('Helpers')
const fs = require('fs');
const sha1 = require('js-sha1');
class LaboratoryController extends AdminController {    

      constructor(){
        super();
        this.title="آزمایشگاه";
      }


      async grid({request ,view}){
        var grid=  new Grid(Laboratory,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('therapist_id', __('therapist_id'));
        grid.column('license_number', __('license_number'));
        grid.column('tel', __('tel'));
        grid.column('bank', __('bank'));
        grid.column('account_number', __('account_number'));
        grid.column('card_number', __('card_number'));
        grid.column('sheba_number', __('sheba_number'));
        grid.column('avatar', __('avatar'));
        grid.column('address', __('address'));
        grid.column('economic_code', __('economic_code'));
        grid.column('contract_number', __('contract_number'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        grid.disableDelete();
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(Laboratory);
        if (id != null) {
            await form.edit(id);
        }
        if (id == null) {
          form.text('name', __('عنوان'));
          form.text('lastname', __('بامدیریت'));
        }
        form.text('therapist_id', __('therapist_id'));
        form.text('license_number', __('license_number'));
        form.text('tel', __('tel'));
        form.text('mobile', __('mobile'));
        form.text('bank', __('bank'));
        form.text('account_number', __('account_number'));
        form.text('card_number', __('card_number'));
        form.text('sheba_number', __('sheba_number'));
        form.image('avatar', __('avatar'));
        form.textarea('address', __('address'));
        form.text('economic_code', __('economic_code'));
        form.text('contract_number', __('contract_number'));
        form.password('password', __('password'));
        form.map(__('map'));

        return form.render();
      }


      async update({ request, view, params, session }) {


        const avatar =  request.file('avatar', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        })
    
        if(avatar!=null){
          var fileName = `${new Date().getTime()}.${avatar.extname}`
          var fileavatar='/uploads/nurses/'+fileName;
          await this.sleep(2000);
          if(process.platform=='win32'){
          var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\nurses\\'+fileName);
          }else{
            var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/nurses/'+fileName);
          }
    
          var record = await Laboratory.query().where('id', '=', params.id).update({avatar:fileavatar });
        }
    


        var alldata=request.all();

        delete alldata['reconfirm-password'];

        if(request.input('password')!='' && request.input('password') != null){
          alldata['password']=sha1(request.input('password'));
        }else{
          delete alldata['password'];
        }
       



        try {
            var record = await Laboratory.query().where('id', '=', params.id).update({...alldata, updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async   store({ request, view, session,response }) {

        const avatar =  request.file('avatar', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        })
        var fileName = `${new Date().getTime()}.${avatar.extname}`
        var fileavatar='/uploads/laboratory/'+fileName;
        await this.sleep(2000);
        if(process.platform=='win32'){
        var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\laboratory\\'+fileName);
        }else{
          var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/laboratory/'+fileName);
        }

        try {
          var parent = await Therapist.query().insert({
            mobile: request.input('mobile'),
            name: request.input('name'),
            lastname: request.input('lastname'),
            type:'laboratory',
            created_at: new Date().toISOString().slice(0, 19).replace('T', ' '),
            updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ')
          })
        } catch (err) {
          this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
         return response.redirect(request.originalUrl().replace('/create', ''));
        }
    
    
        var data={
          ...request.all(),
          created_at: new Date().toISOString().slice(0, 19).replace('T', ' '),
          updated_at: new Date().toISOString().slice(0, 19).replace('T', ' '),
          name:undefined,
          lastname:undefined,
          therapist_id:parent[0],
          avatar:fileavatar,
          password:sha1(request.input('password')),
         };

         delete data.name;
         delete data.lastname;
         delete data['reconfirm-password'];

        try {
            var record = await Laboratory.query().insert(data);
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

       return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await Laboratory.query().where('id', '=', params.id).delete();
                await  Therapist.where('id', '=',parent[0]).update({
                  type_id:record[0]
                });
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = LaboratoryController



