
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const News = use('App/Models/News');
const __ = use('App/Class/Fa');
const Helpers = use('Helpers')
const fs = require('fs');
const sharp = require('sharp');
class NewsController extends AdminController {    

      constructor(){
        super();
        this.title="مدیریت اخبار";
      }


      async grid({request ,view}){
        var grid=  new Grid(News,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('title', __('title'));
        grid.column('fulltext', __('fulltext'));
        grid.column('images', __('images')).image();

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(News);
        if (id != null) {
            await form.edit(id);
        }
                form.text('title', __('title'));
        form.textarea('fulltext', __('fulltext'));
        form.image('images', __('images')+'343*193');

        return form.render();
      }


      async update({ request, view, params, session }) {

        const avatar =  request.file('images', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        });

        if(avatar!=null){

        var fileName = `${new Date().getTime()}.${avatar.extname}`
        var fileavatar='/uploads/news/'+fileName;
        await this.sleep(2000);
        if(process.platform=='win32'){

          // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\banners\\'+fileName);
            await sharp(avatar.tmpPath).resize(343,193, { fit:  "cover" }).toFile(Helpers.publicPath()+'\\uploads\\news\\'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
          }else{

            // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/banners/'+fileName);
            await sharp(avatar.tmpPath).resize(343,193, { fit:  "cover" }).toFile(Helpers.publicPath()+'/uploads/news/'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
         
          }

        }else{
           var fileavatar=null;
        }

   

        try {
          if(avatar!=null){
            var record = await News.query().where('id', '=', params.id).update({...request.all(),images:fileavatar, updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
          }else{
            var record = await News.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        
          }  
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async   store({ request, view, session,response }) {

       
      
        
        const avatar =  request.file('images', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        });

        if(avatar!=null){

        var fileName = `${new Date().getTime()}.${avatar.extname}`
        var fileavatar='/uploads/news/'+fileName;
        await this.sleep(2000);
        if(process.platform=='win32'){

          // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\banners\\'+fileName);
            await sharp(avatar.tmpPath).resize(343,193, { fit:  "cover" }).toFile(Helpers.publicPath()+'\\uploads\\news\\'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
          }else{

            // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/banners/'+fileName);
            await sharp(avatar.tmpPath).resize(343,193, { fit:  "cover" }).toFile(Helpers.publicPath()+'/uploads/news/'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
         
          }

        }else{
           var fileavatar=null;
        }
       


        try {
            var record = await News.query().insert({...request.all(),images:fileavatar, created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

       return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await News.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = NewsController



