
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const Prescription = use('App/Models/Prescription');
const __ = use('App/Class/Fa');
class PrescriptionController extends AdminController {    

      constructor(){
        super();
        this.title="نسخه داروخانه ";
      }


      async grid({request ,view}){
        var grid=  new Grid(Prescription,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('user_id', __('user_id'));
        grid.column('therapist_id', __('therapist_id'));
        grid.column('request_id', __('request_id'));
        grid.column('therapist_drogstore_id', __('therapist_drogstore_id'));
        grid.column('price', __('price'));
        grid.column('status', __('status'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(Prescription);
        if (id != null) {
            await form.edit(id);
        }
                form.text('user_id', __('user_id'));
        form.text('therapist_id', __('therapist_id'));
        form.text('request_id', __('request_id'));
        form.text('therapist_drogstore_id', __('therapist_drogstore_id'));
        form.text('price', __('price'));
        form.text('status', __('status'));

        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await Prescription.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async   store({ request, view, session,response }) {

        try {
            var record = await Prescription.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

       return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await Prescription.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = PrescriptionController



