
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const Product = use('App/Models/Shop/Product');
const Category = use('App/Models/Shop/Category');
const __ = use('App/Class/Fa');
const Helpers = use('Helpers')
const fs = require('fs');
const sharp = require('sharp');
class ProductController extends AdminController {    

      constructor(){
        super();
        this.title="محصولات";
      }


      async grid({request ,view}){
        var grid=  new Grid(Product,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('category_id', __('category_id'));
        grid.column('title', __('title'));
        grid.column('price', __('price'));
        grid.column('image', __('image')).image();
        grid.column('description', __('description'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(Product);
        if (id != null) {
            await form.edit(id);
        }

        var s = await Category.query().fetch();

        s=s.toJSON();

        

        form.select('category_id', __('category_id')).options(s);
        form.text('title', __('title'));
        form.text('price', __('price'));
        form.image('image', __('image')+' 512*512');
        form.text('description', __('description'));

        form.select('is_favorite',__('is_favorite')).options([{id:0,title:'غیر محبوب'},{id:1,title:'محبوب'}]);

        return form.render();
      }


      async update({ request, view, params, session }) {

        const avatar =  request.file('image', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        });

        if(avatar!=null){
          
          var fileName = `${new Date().getTime()}.${avatar.extname}`
          var fileavatar='/uploads/shop/'+fileName;
          await this.sleep(2000);
          if(process.platform=='win32'){
          // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\shop\\'+fileName);
          await sharp(avatar.tmpPath).resize(512,512, { fit:  "cover" }).toFile(Helpers.publicPath()+'\\uploads\\shop\\'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
          }else{
            await sharp(avatar.tmpPath).resize(512,512, { fit:  "cover" }).toFile(Helpers.publicPath()+'/uploads/shop/'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });;
            //var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/shop/'+fileName);
          }
  
          }else{
             var fileavatar=null;
          }

        try {
          if(avatar!=null){
            var record = await Product.query().where('id', '=', params.id).update({...request.all(),image:fileavatar, updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
          }else{
            var record = await Product.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
        
          }this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async store({ request, view, session,response }) {

        const avatar =  request.file('image', { 
          maxSize: '2mb',
          allowedExtensions: ['jpg', 'png', 'jpeg']
        });

        if(avatar!=null){

          

          var fileName = `${new Date().getTime()}.${avatar.extname}`
          var fileavatar='/uploads/shop/'+fileName;
          await this.sleep(2000);
          if(process.platform=='win32'){
            // var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\shop\\'+fileName);
            await sharp(avatar.tmpPath).resize(512,512, { fit:  "cover" }).toFile(Helpers.publicPath()+'\\uploads\\shop\\'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });
            }else{
              await sharp(avatar.tmpPath).resize(512,512, { fit:  "cover" }).toFile(Helpers.publicPath()+'/uploads/shop/'+fileName).then( data => { console.log(data) }).catch( err => { console.log(err) });
              //var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/shop/'+fileName);
            }
  
          }else{
             var fileavatar=null;
          }

        try {
            var record = await Product.query().insert({...request.all(),image:fileavatar, created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await Product.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = ProductController



