
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const Request = use('App/Models/Request');
const __ = use('App/Class/Fa');
class RequestController extends AdminController {    

      constructor(){
        super();
        this.title="مدیریت درخواست ها";
      }


      async grid({request ,view}){
        var grid=  new Grid(Request,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('user_id', __('user_id'));
        grid.column('status', __('status'));
        grid.column('therapist_id', __('therapist_id'));
        grid.column('serivce', __('serivce'));
        grid.column('extra', __('extra'));
        grid.column('price', __('price'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(Request);
        if (id != null) {
            await form.edit(id);
        }

        if(id == null){
          form.text('user_id', __('user_id'));
          form.text('status', __('status'));
          form.text('therapist_id', __('therapist_id'));
          form.text('serivce', __('serivce'));
          form.text('extra', __('extra'));
          form.text('price', __('price'));
        }else{
          //'request','accept','onway','doing','done','cancel','paid','return'
          form.select('status', __('status')).options([
            {id:'request',title:'ثبت درخواست'},
            {id:'accept',title:'تایید تراپیست'},
            {id:'onway',title:'در راه'},
            {id:'doing',title:'در حال انجام'},
            {id:'done',title:'انجام شده'},
            {id:'cancel',title:'لغو شده'},
            {id:'paid',title:'پرداخت شده'},
          ]);
        }
       

        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await Request.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async   store({ request, view, session,response }) {

        try {
            var record = await Request.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

       return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await Request.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = RequestController



