
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid = use('App/Class/Grid');
const Form = use('App/Class/Form');
const ServicePricing = use('App/Models/ServicePricing');
const ServiceCategory = use('App/Models/ServiceCategory');
const __ = use('App/Class/Fa');
const Helpers = use('Helpers')
const fs = require('fs');
class ServicePricingController extends AdminController {

  constructor() {
    super();
    this.title = "مدیریت قیمت گذاری";
  }


  async grid({ request, view }) {
    var grid = new Grid(ServicePricing, request.originalUrl());
    grid.column('id', __('Id'));
    grid.column('price', __('price'));
    grid.column('title', __('title'));
    grid.column('icon',__('icon')).image();


    grid.column('updated_at', __('updatedAt')).persiandate();
    grid.column('created_at', __('createdAt')).persiandate();;
    return grid.render();
  }


  async form({ request, view }, id = null) {
    var form = new Form(ServicePricing);
    if (id != null) {
      await form.edit(id);
    }
    form.number('price', __('price'));
    form.text('title', __('title'));
    form.image('icon',__('icon'));
    var sc=await ServiceCategory.all();
    var scjson=sc.toJSON();
    scjson.push({id:null,title:'عمومی'});



    form.select('category_id',__('category')).options(scjson);

    return form.render();
  }


  async update({ request, view, params, session }) {

    const avatar =  request.file('icon', { 
      maxSize: '2mb',
      allowedExtensions: ['jpg', 'png', 'jpeg','svg']
    })

    if(avatar!=null){
      var updateavater=true;
    var fileName = `${new Date().getTime()}.${avatar.extname}`
    var fileicon='/uploads/services/'+fileName;
    await this.sleep(2000);
    if(process.platform=='win32'){
    var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\services\\'+fileName);
    }else{
      var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/services/'+fileName);
    }
    }else{
      var updateavater=false;
    }



    try {
      if(updateavater){
      var record = await ServicePricing.query().where('id', '=', params.id).update({ ...request.all(),icon:fileicon, updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
      }else{
        var record = await ServicePricing.query().where('id', '=', params.id).update({ ...request.all(),updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
      
      }
      this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
    } catch (err) {
      this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
    }

    return this.show({ request, view, params, session });

  }


  async   store({ request, view, session,response }) {

    const avatar =  request.file('icon', { 
      maxSize: '2mb',
      allowedExtensions: ['jpg', 'png', 'jpeg','svg']
    })
    var fileName = `${new Date().getTime()}.${avatar.extname}`
    var fileicon='/uploads/services/'+fileName;
    await this.sleep(2000);
    if(process.platform=='win32'){
    var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\services\\'+fileName);
    }else{
      var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/services/'+fileName);
    }



    try {
      var record = await ServicePricing.query().insert({ ...request.all(),icon:fileicon, created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
      this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
    } catch (err) {
      this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
    }

   return response.redirect(request.originalUrl().replace('/create', ''));
  }


  async remove({ request, view, session, params ,response }) {

    try {
      var record = await ServicePricing.query().where('id', '=', params.id).delete();
      this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
    } catch (err) {
      this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
    }

    return this.index({ request, view, session,response});

  }



}

module.exports = ServicePricingController



