
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const UserAddress = use('App/Models/UserAddress');
const __ = use('App/Class/Fa');
class UserAddressController extends AdminController {    

      constructor(){
        super();
        this.title="آدرس های کاربر";
      }


      async grid({request ,view}){
        var grid=  new Grid(UserAddress,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('user_id', __('user_id'));
        grid.column('address', __('address'));
        grid.column('number', __('number'));
        grid.column('unit', __('unit'));
        grid.column('latitude', __('latitude'));
        grid.column('longitude', __('longitude'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(UserAddress);
        if (id != null) {
            await form.edit(id);
        }
                form.text('user_id', __('user_id'));
        form.text('address', __('address'));
        form.text('number', __('number'));
        form.text('unit', __('unit'));
        form.text('latitude', __('latitude'));
        form.text('longitude', __('longitude'));

        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await UserAddress.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async   store({ request, view, session,response }) {

        try {
            var record = await UserAddress.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

       return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await UserAddress.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = UserAddressController



