
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid=use('App/Class/Grid');
const Form=use('App/Class/Form');
const UserPoint = use('App/Models/UserPoint');
const __ = use('App/Class/Fa');
class UserPointController extends AdminController {    

      constructor(){
        super();
        this.title="مدیریت امتیاز های کاربر";
      }


      async grid({request ,view}){
        var grid=  new Grid(UserPoint,request.originalUrl()); 
        grid.column('id', __('Id'));
                grid.column('user_id', __('user_id'));
        grid.column('request_id', __('request_id'));
        grid.column('point', __('point'));
        grid.column('hash', __('hash'));

        grid.column('updated_at', __('updatedAt')).persiandate();
        grid.column('created_at', __('createdAt')).persiandate();;
        return grid.render();
      }


      async form({ request, view }, id = null) {
        var form = new Form(UserPoint);
        if (id != null) {
            await form.edit(id);
        }
                form.text('user_id', __('user_id'));
        form.text('request_id', __('request_id'));
        form.text('point', __('point'));
        form.text('hash', __('hash'));

        return form.render();
      }


      async update({ request, view, params, session }) {

        try {
            var record = await UserPoint.query().where('id', '=', params.id).update({...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

        return this.show({ request, view, params, session });

      }


      async   store({ request, view, session,response }) {

        try {
            var record = await UserPoint.query().insert({...request.all(), created_at: new Date().toISOString().slice(0, 19).replace('T', ' '), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
            this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
        } catch (err) {
            this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
        }

       return response.redirect(request.originalUrl().replace('/create', ''));
      }


      async remove({ request, view, session, params ,response }) {

            try {
                var record = await UserPoint.query().where('id', '=', params.id).delete();
                this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
            } catch (err) {
                this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
            }

            return this.index({ request, view, session,response});

      }



}

module.exports = UserPointController



