
'use strict'
const AdminController = use('App/Controllers/Http/Admin/AdminController');
const Grid = use('App/Class/Grid');
const Form = use('App/Class/Form');
const Doctor = use('App/Models/Doctor');
const Therapist = use('App/Models/Therapist');
const __ = use('App/Class/Fa');
const Helpers = use('Helpers')
const fs = require('fs');
const Request = use('App/Models/Request');
class doctorController extends AdminController {

  constructor() {
    super();
    this.title = "مدیریت پزشک";
  }


  async grid({ request, view }) {
    var grid = new Grid(Doctor, request.originalUrl());
    grid.column('id', __('Id'));
    grid.column('therapist_id', __('therapist_id'));
    grid.column('license_number', __('license_number'));
    grid.column('medical_council_code', __('medical_council_code'));
    grid.column('mobile', __('mobile')).display(function(val){
      return '<a href="/admin/doctors/history/'+val+'">'+val+'</a>'

    });
    // grid.column('bank', __('bank'));
    // grid.column('account_number', __('account_number'));
    // grid.column('card_number', __('card_number'));
    // grid.column('sheba_number', __('sheba_number'));
    grid.column('avatar', __('avatar'));
    grid.column('national_code', __('national_code'));
    // grid.column('contract_number', __('contract_number'));

    grid.column('updated_at', __('updatedAt')).persiandate();
    grid.column('created_at', __('createdAt')).persiandate();;
    grid.disableDelete();
    return grid.render();
  }


  async form({ request, view }, id = null) {
    var form = new Form(Doctor);
    if (id != null) {
      await form.edit(id);
    }
    if (id == null) {
      form.text('name', __('name'));
      form.text('lastname', __('lastname'));
    }
    form.text('therapist_id', __('therapist_id'));
    form.text('license_number', __('license_number'));
    form.text('medical_council_code', __('medical_council_code'));
    form.text('mobile', __('mobile'));
    form.text('bank', __('bank'));
    form.text('account_number', __('account_number'));
    form.text('card_number', __('card_number'));
    form.text('sheba_number', __('sheba_number'));
    form.image('avatar', __('avatar'));
    form.text('national_code', __('national_code'));
    form.text('contract_number', __('contract_number'));

    return form.render();
  }


  async update({ request, view, params, session }) {


    const avatar =  request.file('avatar', { 
      maxSize: '2mb',
      allowedExtensions: ['jpg', 'png', 'jpeg']
    })

    if(avatar!=null){
      var fileName = `${new Date().getTime()}.${avatar.extname}`
      var fileavatar='/uploads/nurses/'+fileName;
      await this.sleep(2000);
      if(process.platform=='win32'){
      var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\nurses\\'+fileName);
      }else{
        var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/nurses/'+fileName);
      }

      var record = await Doctor.query().where('id', '=', params.id).update({avatar:fileavatar });
    }

    try {
      var record = await Doctor.query().where('id', '=', params.id).update({ ...request.all(), updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ') });
      this.handleError('<div class="alert alert-success">ویرایش با موفقیت انجام شد</div>', { session })
    } catch (err) {
      this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
    }

    return this.show({ request, view, params, session });

  }


  async   store({ request, view, session,response }) {
    
    const avatar =  request.file('avatar', { 
      maxSize: '2mb',
      allowedExtensions: ['jpg', 'png', 'jpeg']
    })
    var fileName = `${new Date().getTime()}.${avatar.extname}`
    var fileavatar='/uploads/doctors/'+fileName;
    await this.sleep(2000);
    if(process.platform=='win32'){
    var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'\\uploads\\doctors\\'+fileName);
    }else{
      var c=await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath()+'/uploads/doctors/'+fileName);
    }

   


    try {
      var parent = await Therapist.query().insert({
        mobile: request.input('mobile'),
        name: request.input('name'),
        lastname: request.input('lastname'),
        type:'doctor',
        created_at: new Date().toISOString().slice(0, 19).replace('T', ' '),
        updated_at: new Date().toISOString().slice(0, 19).replace('T', ' ')
      })
    } catch (err) {
      this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
     return response.redirect(request.originalUrl().replace('/create', ''));
    }


    






    

  


    var data={
      ...request.all(),
      created_at: new Date().toISOString().slice(0, 19).replace('T', ' '),
      updated_at: new Date().toISOString().slice(0, 19).replace('T', ' '),
      name:undefined,
      lastname:undefined,
      
      therapist_id:parent[0],
      avatar:fileavatar
     };

     delete data.name;
     delete data.lastname;
    

     
    


    try {
      var record = await Doctor.query().insert(data);
      await  Therapist.query().where('id', '=',parent[0]).update({
        type_id:record[0]
      });


      this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
    } catch (err) {
      this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
    }

   return response.redirect(request.originalUrl().replace('/create', ''));
  }


  async remove({ request, view, session, params ,response }) {

    try {
      var record = await Doctor.query().where('id', '=', params.id).delete();
      this.handleError('<div class="alert alert-success"> ثبت موفقیت انجام شد</div>', { session })
    } catch (err) {
      this.handleError('<div class="alert alert-danger">' + err + '</div>', { session });
    }

    return this.index({ request, view, session,response});

  }

  async history({request,view,session,params}){
    var record = await Doctor.query().where('mobile', '=', params.mobile).with('therapist').first();

    

    var re=await Request.query().where('therapist_id','=',record.therapist_id).with('user').with('therapist').with('address').fetch();

    record=record.toJSON();

    

    return view.render('admin.reportdoctor',{ requests:re.toJSON(),title:'گزارش فعالیت های پزشک  '+record.therapist.name+' '+record.therapist.lastname });
  }



}

module.exports = doctorController



