'use strict'

const Holyday = use('App/Models/Holyday')
const SamplingSan= use('App/Models/SamplingSan');
const ActiveArea = use('App/Models/ActiveArea');
const JDate = require('jalali-date');
class BusinessController {
    async showDays({ request, response }){

       


        var days=[]
        var today = new Date();
        for(var n = 1; n < 10; n++){
        
        let nextDay = new Date(today);
        nextDay.setDate(today.getDate() + n);
        days.push({id:nextDay,title:new JDate(nextDay).format('dddd DD MMMM YYYY')});
        }
        
        var holydays= await  Holyday.query().whereBetween('holyday',[days[0].id,days[8].id]).fetch();
        holydays=holydays.toJSON();

        days=days.filter(d=> holydays.filter(h=>new Date(h.holyday).getDate() == new Date(d.id).getDate()).length == 0);

        days=days.slice(0,3);



        return { code: "200", error: false, message: "در خواست با موفقیت انجام شد", data:days }
    }


    async showSans({request,response}){
        var sans=await SamplingSan.query().fetch();

        return { code: "200", error: false, message: "در خواست با موفقیت انجام شد", data:sans.toJSON()}
    }

    async showActiveArea({request,response}){
        var area=await ActiveArea.query().fetch();
        return { code: "200", error: false, message: "در خواست با موفقیت انجام شد", data:area.toJSON()}
    }
}

module.exports = BusinessController
