'use strict'

class CaptchaController {
    constructor() {
        const { registerFont,createCanvas } = require("canvas");
        registerFont( 'arial.ttf', { family: "arial" } );
        // https://gist.github.com/wesbos/1bb53baf84f6f58080548867290ac2b5
        const alternateCapitals = str =>
            [...str].map((char, i) => char[`to${i % 2 ? "Upper" : "Lower"}Case`]()).join("");

        // Get a random string of alphanumeric characters
        const randomText = () =>
            alternateCapitals(
                Math.random()
                    .toString(36)
                    .substring(2, 8)
            );

        const FONTBASE = 200;
        const FONTSIZE = 35;

        // Get a font size relative to base size and canvas width
        const relativeFont = width => {
            const ratio = FONTSIZE / FONTBASE;
            const size = width * ratio;
            return `${size}px serif`;
        };

        const  getRandomInt = (max) => {
            return Math.floor(Math.random() * Math.floor(max));
        }
          

        // Get a float between min and max
        const arbitraryRandom = (min, max) => Math.random() * (max - min) + min;

        // Get a rotation between -degrees and degrees converted to radians
        const randomRotation = (degrees = 7) => (arbitraryRandom(-degrees, degrees) * Math.PI) / 180;

        const configureText = (ctx, width, height) => {
            // ctx.font = relativeFont(width);
            ctx.font= "normal normal 270px arial";

            ctx.textBaseline = "middle";
            ctx.textAlign = "center";
            const text = randomText().toLowerCase();
            // const text='🌹';
            var color=getRandomInt(5);

            ctx.fillStyle = "pink";

            if(color==1){
                ctx.fillStyle = "red";
            }

            if(color==2){
                ctx.fillStyle = "blue";
            }

            if(color==3){
                ctx.fillStyle = "green";
            }

            if(color==4){
                ctx.fillStyle = "purple";
            }
            ctx.lineWidth = "10";
            ctx.strokeStyle = "black";
            ctx.beginPath();
            ctx.moveTo(0, 0);
            ctx.lineTo(1000, getRandomInt(400));
            ctx.stroke();

            ctx.moveTo(0, 0);
            ctx.beginPath();
            ctx.moveTo(1000, 0);
            ctx.lineTo(getRandomInt(1000), 400);
            ctx.stroke();
           
            ctx.fillText(text, width / 2, height / 2);
            return text;
          };
          
          // Get a PNG dataURL of a captcha image
          const generate = (width, height) => {
            const canvas = createCanvas(width, height);
            const ctx = canvas.getContext("2d");
            ctx.rotate(randomRotation());
            const text = configureText(ctx, width, height);
            return {
              image: canvas.toDataURL(),
              text: text
            };
          };

          this.captcha=generate(1000,400);
    }
}


module.exports = CaptchaController
