'use strict'
const Feedback = use('App/Models/Feedback');
const Support = use('App/Models/Support');
const { validate } = use('Validator')
const Request = use('App/Models/Request');

class FeedbackController {

    async shownofeedback({ request }) {



        var maxid = await Feedback.query().where('user_id', '=', request.user.id).getMax('request_id');


        if (maxid == null) {
            maxid = 0;

        }



        var r = await Request.query().where('user_id', '=', request.user.id).where('id', '>', maxid).whereIn('status',['done']).with('therapist').first();
        if (r == null) {
            return {
                error: 'true',
                message: 'هیچ رکوردی پیدا نشد',
                data: null,
            }
        }
        else {
            return {
                error: 'false',
                message: 'ارسال فید بک',
                data: r,
            }
        }


    }

    async save({ request }) {

        const validation = await validate(request.all(), {
            request_id: 'required',
            star: 'required|integer|min:1|max:5',
            satisfaction: 'required'
        })


        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }


        var f = new Feedback;
        f.user_id = request.user.id;
        f.request_id = request.input('request_id');
        f.star = request.input('star');
        f.satisfaction = JSON.stringify({
            comment: request.input('comment'),
            data:request.input('satisfaction'),
        });


        try {
            await f.save();
            return { code: "200", error: false, message: "ثبت با موفقیت انجام شد", }
        } catch (e) {
            return { code: "500", error: true, message: "خطا در اعتبار سنجی", "data": e }
        }



    }

    async saveSupport({ request }) {
        const validation = await validate(request.all(), {
            message: 'required',

        })


        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }

        var s = new Support;
        s.user_id = request.user.id;
        s.message = request.input('message');
        s.save();
        return { code: "200", error: false, message: "ثبت درخواست با موفقیت انجام شد" };


    }
}

module.exports = FeedbackController
