'use strict'
const Banner = use('App/Models/Banner')
const News = use('App/Models/News')
const Category = use('App/Models/Shop/Category');
const Product = use('App/Models/Shop/Product');
const Page = use('App/Models/Page');
const ServicePricing = use('App/Models/ServicePricing');
class HomeController {

    async showBanner({ request, response }) {
        var banner=await Banner.query().fetch();
        return { code: "200", error: false, message: "در خواست با موفقیت انجام شد", data: banner.toJSON() }
    }

    async showPages({request,response}){
        var pages=await Page.query().fetch();
        return {code:"200",error:false,message:"در خواست با موفقیت انجام شد",data:pages.toJSON()};
    }

    async showNews({ request, response }) {
        var news=await News.query().fetch();
        return { code: "200", error: false, message: "در خواست با موفقیت انجام شد", data: news.toJSON() }
    }

    async showCategories({ request, response }) {
        var c=await Category.query().fetch();
        return { code: "200", error: false, message: "در خواست با موفقیت انجام شد", data: c.toJSON() }
    }

    async showProducts({ request, response }) {
        var p=await Product.query().fetch();
        return { code: "200", error: false, message: "در خواست با موفقیت انجام شد", data: p.toJSON() }
    }

    async showDoctorVisitPrice(request,response){
       var visitprice=await  ServicePricing.query().whereIn('title',['گواهی سلامت دانش آموز','ویزیت در منزل','گواهی فوت']).fetch();
       return { code: "200", error: false, message: "در خواست با موفقیت انجام شد", data: visitprice.toJSON() }
    }



}

module.exports = HomeController
