'use strict'


const TherapistWallet = use('App/Models/TherapistWallet');
const TherapistDeposit = use('App/Models/TherapistDeposit');

var sha256 = require('sha256');




class TherapistWalletManagerController {

    async saveDeposit({request}){
        
        var td= new TherapistDeposit;
        td.amount=await this.showBalance({request:request});
        td.therapist_id=request.therapist.id;
        await td.save();
        return { code: "200", error: false, message: "ثبت با موفقیت انجام شد"}
        
    }

    async showWallet({request}){
        var myuv=await TherapistWallet.query().where('therapist_id','=',request.therapist.id).fetch();
        return myuv.toJSON();

    }

    async showBalance({request}){
        var sum=await TherapistWallet.query().where('therapist_id','=',request.therapist.id).getSum('amount');
        return sum;
    }

    async Increase(therapistId, amount, type = null, type_id = null, descriptions = null) {

        if (parseInt(amount) > 0) {
            let uv = new TherapistWallet();
            uv.therapist_id = therapistId;
            uv.amount = parseInt(amount);
            uv.type = type;
            uv.type_id = type_id;
            uv.descriptions = descriptions;

            var lastuv = await TherapistWallet.query().where('therapist_id', '=', therapistId).orderBy('id', 'desc').first();

            var lasthash = null;
            if (lastuv != null) {
                lasthash = lastuv.hash
            }
            await uv.save();



            var mystr = sha256(JSON.stringify({ ...uv.toJSON(), hash: lasthash }))



            uv.hash = mystr;

            await uv.save();




        }

    }



    async Decrease(therapistId, amount, type = null, type_id = null, descriptions = null){

        if (parseInt(amount) > 0) {
            let uv = new TherapistWallet();
            uv.therapist_id = therapistId;
            uv.amount = parseInt(amount)*(-1);
            uv.type = type;
            uv.type_id = type_id;
            uv.descriptions = descriptions;

            var lastuv = await TherapistWallet.query().where('therapist_id', '=', therapistId).orderBy('id', 'desc').first();

            var lasthash = null;
            if (lastuv != null) {
                lasthash = lastuv.hash
            }
            await uv.save();



            var mystr = sha256(JSON.stringify({ ...uv.toJSON(), hash: lasthash }))



            uv.hash = mystr;

            await uv.save();




        }

    }
}


module.exports = TherapistWalletManagerController
