'use strict'

const axios = require('axios');
const Env = use('Env');
const Transaction = use('App/Models/Transaction');
const UserAddress = use('App/Models/UserAddress');
const UserShopAddress = use('App/Models/UserShopAddress');
const Config = use('App/Models/Config');
const UserMessage = use('App/Models/UserMessage');
const User = use('App/Models/User');
const Insurance = use('App/Models/Insurance');
const UserFirebaseToken = use('App/Models/UserFirebaseToken');

const { validate } = use('Validator')

const Helpers = use('Helpers')
const fs = require('fs');

const Order=use('App/Models/Shop/Order');
const OrderDetail=use('App/Models/Shop/OrderDetail');
const ShopUserAddress=use('App/Models/Shop/ShopUserAddress');

const UserWalletManagerController = use('App/Controllers/Http/UserWalletManagerController');



class UserController {
    async charge({ request, response }) {

        const validation = await validate(request.all(), {
            amount: 'required|integer',
        })


        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }


        var tc = new Transaction;
        tc.user_id = request.user.id;
        tc.amount = request.input('amount');
        tc.status = 'unpaid';
        tc.getway = 'zarinpal';
        await tc.save();


        var zrequest = await axios.post('https://sandbox.zarinpal.com/pg/rest/WebGate/PaymentRequest.json', {
            MerchantID: "277ae786-d165-11e9-910c-000c295eb8fc",
            Amount: request.input('amount'),
            CallbackURL: "http://194.5.205.91:3333/api/v1/client/user/charge/callback/" + tc.id,
            Description: "tc_id:" + tc.id
        })

        console.log(zrequest.data)

        if (zrequest.data.Status == "100") {
            return response.json({ url: "https://sandbox.zarinpal.com/pg/StartPay/" + zrequest.data.Authority });
        } else {
            return { code: "500", error: true, message: "خطای سرور", "data": { status: zrequest.data.Status } }
        }




    }

    async callbackOrders({ request, response, params, view }) {

        var o = await Order.find(params.id);


        var status = 'not ok';


       
        // var zrequest = await axios.post('https://www.zarinpal.com/pg/rest/WebGate/PaymentVerification.json', {
        //     MerchantID: "277ae786-d165-11e9-910c-000c295eb8fc",
        //     Amount: o.payable,
        //     Authority: request.input('Authority'),

        // });

        if (true ||zrequest.data.Status == 100) {

            o.tracking_code = '12345'; //zrequest.data.RefID;
            o.status = 'paid';
            await o.save();

            var status = 'ok';

        }


        return view.render('bank', { status: status, amount: o.payable });

    }

    async callbackCharge({ request, response, params, view }) {

        var tc = await Transaction.find(params.id);


        var status = 'not ok';



        var zrequest = await axios.post('https://sandbox.zarinpal.com/pg/rest/WebGate/PaymentVerification.json', {
            MerchantID: "277ae786-d165-11e9-910c-000c295eb8fc",
            Amount: tc.amount,
            Authority: request.input('Authority'),

        });

        if (zrequest.data.Status == 100) {

            tc.digital_code = zrequest.data.RefID;
            tc.status = 'paid';
            await tc.save();

            var uwm = new UserWalletManagerController;


            await uwm.Increase(tc.user_id, tc.amount, 'zarinpal', tc.id, 'پرداخت مستقیم از زرین پال به مبلغ ' + tc.amount + ' تومان');

            var status = 'ok';

        }


        return view.render('bank', { status: status, amount: tc.amount });



    }

    async removeAddressTitle({ request, response, params }) {




        const validation = await validate({ id: params.id }, {
            id: 'required',

        })

        var ua = await UserAddress.query().where('user_id', '=', request.user.id).where('id', '=', params.id).first();
        ua.title = null;


        try {
            await ua.save();
            return { code: "200", error: false, message: "ثبت با موفقیت انجام شد", }
        } catch (e) {
            return { code: "500", error: true, message: "خطا در اعتبار سنجی", "data": e }
        }

    }

    async showOrders({request,response}){
        var orders= await  Order.query().where('user_id','=',request.user.id).whereIn('status',['paid','complete','deliver']).with('detail').with('detail.product').fetch();

        return {code:200,error:false,message:'درخواست با موفقیت انجام شد',data:orders.toJSON()};

    }

    async saveOrders({ request, response }){
        const validation = await validate(request.all(),{
            wallet:'required',
            baskets:'required',
            address:'required',
        });


        var sum=0;
        var neworder=new Order;
        neworder.user_id=request.user.id;
        neworder.status='register';
        neworder.delivery_address=request.input('address').address;
        await neworder.save();

        var address=request.input('address');

        let usershopaddress = new UserShopAddress();
        usershopaddress.user_id = request.user.id;
        usershopaddress.address = address.address;
        usershopaddress.mobile =address.mobile;
        usershopaddress.city = address.city;
        usershopaddress.state = address.state;
        usershopaddress.latitude = address.longitude;
        usershopaddress.longitude = address.longitude;
        usershopaddress.name = address.fullname;

        var baskets=request.input('baskets');
        baskets.forEach(async function(b){
            var neworderdetail=new OrderDetail;
            neworderdetail.order_id=neworder.id;
            neworderdetail.product_id=b.id;
            neworderdetail.amount=b.count;
            neworderdetail.price=b.price;
            neworderdetail.total_price=b.price*b.count;
            sum+=neworderdetail.total_price;

            await neworderdetail.save();


        })

        neworder.total_price=sum;
        await  neworder.save();

        

        if(request.input('wallet')){
            var user=await User.find(request.user.id);
            var Balance=await user.wallet().getSum('amount')
            if(Balance<sum){
                return {code:200,error:true,message:'موجودی کیف پول شما کافی نیست'};
            }else{
                var uwm = new UserWalletManagerController;
                await uwm.Decrease(request.user.id,sum,'orders',neworder.id,'کسر مبلغ '+sum+' تومان بابت    سفارش محصول');
                neworder.status='paid';
                neworder.tracking_code='کسر از کیف پول';
                await neworder.save();
                return {code:200,error:false,message:'ثبت با موفقیت انجام شد'};
            }
        }else{
            var zrequest = await axios.post('https://sandbox.zarinpal.com/pg/rest/WebGate/PaymentRequest.json', {
                MerchantID: "277ae786-d165-11e9-910c-000c295eb8fc",
                Amount: sum,
                CallbackURL: "http://194.5.205.91:3333/api/v1/client/orders/callback/" + neworder.id,
                Description: "tc_id:" + neworder.id
            })

            if (zrequest.data.Status == "100") {
                return response.json({ url: "https://sandbox.zarinpal.com/pg/StartPay/" + zrequest.data.Authority });
            } else {
                return { code: "500", error: true, message: "خطای سرور", "data": { status: zrequest.data.Status } }
            }

            
        }


       

    }


    async saveShopAddress({ request, response }) {
        const validation = await validate(request.all(), {
            address: 'required',
            latitude: 'required',
            longitude: 'required',
            city: 'required',
            state: 'required',
            name: 'required',
            mobile: 'required',
        });

        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }

        let usershopaddress = new UserShopAddress();
        usershopaddress.user_id = request.user.id;
        usershopaddress.address = request.input('address');
        usershopaddress.mobile = request.input('mobile');
        usershopaddress.city = request.input('city');
        usershopaddress.state = request.input('state');
        usershopaddress.latitude = request.input('latitude');
        usershopaddress.longitude = request.input('longitude');
        usershopaddress.name = request.input('name', null);

        try {
            await usershopaddress.save();
            return { code: "200", error: false, message: "ثبت با موفقیت انجام شد", }
        } catch (e) {
            return { code: "500", error: true, message: "خطا در اعتبار سنجی", "data": e }
        }


    }


    async ShowShopAddress({request,response}){
        var list=await UserShopAddress.query().where('user_id','=',request.user.id).fetch();
        return list.toJSON();
    }


    async saveAddress({ request, response }) {

        const validation = await validate(request.all(), {
            address: 'required',
            number: 'required|integer',
            unit: 'required|integer',
            latitude: 'required',
            longitude: 'required',
        })



        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }

        let useraddress = new UserAddress();
        useraddress.user_id = request.user.id;
        useraddress.address = request.input('address');
        useraddress.number = request.input('number');
        useraddress.unit = request.input('unit');
        useraddress.latitude = request.input('latitude');
        useraddress.longitude = request.input('longitude');
        useraddress.title = request.input('title', null);

        try {
            await useraddress.save();
            return { code: "200", error: false, message: "ثبت با موفقیت انجام شد", }
        } catch (e) {
            return { code: "500", error: true, message: "خطا در اعتبار سنجی", "data": e }
        }





    }

    async showAddress({ request }) {

        var address = await UserAddress.query().where('user_id', '=', request.user.id).where('address', 'like', '%' + request.input('query') + '%').fetch();
        return address.toJSON();
    }


    async showConfig({ request }) {
        var config = await Config.query().fetch();
        return config.toJSON();
    }


    async showMessage({ request }) {
        var messages = await UserMessage.query().where('user_id', '=', request.user.id).fetch();
        return messages.toJSON();
    }

    async showInfo({ request }) {
        return request.user;
    }

    async updateInfo({ request, response }) {

        const validation = await validate(request.all(), {
            email: 'required|email',
            birthdate: 'required',
            fullname: 'required',
            tel: 'required',
            nationalcode: 'required'
        })



        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }

        var myuser = await User.find(request.user.id);
        myuser.email = request.input('email');
        myuser.birthdate = request.input('birthdate');
        myuser.fullname = request.input('fullname');
        myuser.tel = request.input('tel');
        myuser.nationalcode=request.input('nationalcode');
        
        await myuser.save();
        return { code: "200", error: false, message: "ثبت با موفقیت انجام شد", }



    }

    async showInsurance({ request, response }) {
        var ins = await Insurance.query().fetch();
        return { code: "200", error: false, message: "در خواست با موفقیت انجام شد", data: ins.toJSON() }
    }


    async saveTokenFirebase({ request, response }) {
        const validation = await validate(request.all(), {
            token: 'required',

        })



        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }
        if (await UserFirebaseToken.query().where('user_id', '=', request.user.id).where('token', '=', request.input('token')).first() == null) {


            var userfirebasetoken = new UserFirebaseToken;
            userfirebasetoken.user_id = request.user.id;
            userfirebasetoken.token = request.input('token');
            await userfirebasetoken.save();
        }
        return { code: "200", error: false, message: "ثبت با موفقیت انجام شد", }



    }

    sleep(ms) {
        return new Promise(resolve => setTimeout(resolve, ms));
    }



    async saveAvatar({ request, response }) {

        const validation = await validate(request.all(), {
            avatar: 'required',

        })



        if (validation.fails()) {
            return { code: "422", error: true, message: "خطا در اعتبار سنجی", "data": validation.messages() }
        }

        // const avatar = request.file('avatar', {
        //     maxSize: '2mb',
        //     allowedExtensions: ['jpg', 'png', 'jpeg']
        // })
        // var fileName = `${new Date().getTime()}.${request.user.id}.${avatar.extname}`
        // var fileavatar = '/uploads/users/' + fileName;
        // await this.sleep(2000);
        // if (process.platform == 'win32') {
        //     var c = await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath() + '\\uploads\\users\\' + fileName);
        // } else {
        //     var c = await fs.copyFileSync(avatar.tmpPath, Helpers.publicPath() + '/uploads/users/' + fileName);
        // }

        var fileName = `${new Date().getTime()}.${request.user.id}.png`
        var fileavatar = '/uploads/users/' + fileName;

        var body =request.input('avatar');
        var base64Data = body.replace(/^data:image\/png;base64,/,""),
        binaryData = new Buffer(base64Data, 'base64').toString('binary');

        
        await fs.writeFileSync(Helpers.publicPath()+fileavatar, binaryData, "binary");



        var myuser = await User.find(request.user.id);

        myuser.avatar = fileavatar;
        await myuser.save();

        return { code: "200", error: false, message: "آپلود با موفقیت انجام شد" }

    }


    async sendCloudMessage(title, body, user) {

        var uft = await UserFirebaseToken.query().where('user_id', '=', user).fetch();

        uft = uft.toJSON();

        uft.forEach(async function (element) {

            await axios.post('https://fcm.googleapis.com/fcm/send', {
                "content_available": true,
                "mutable_content": true,
                "priority": "high",
                "data": {
                    "imageURL": "https://static.tgju.org/images/iwmf-3.png",
                    "app": "1.0",
                    "syntax": "swift",
                    "type": "notic",
                    "source": {
                        "storyboardID": "TESTVC",
                        "message": "<TESTMESSAGE>",
                        "duration": 0
                    }
                },
                "to": element.token,
                "notification": {
                    "title": title,
                    "body": body,
                    "sound": "default",
                    "badge": 1,
                    "comment_click_action": "https://aloapp.com",
                    "click_action": "blog",
                    "url": "https://aloapp.com",
                    "icon": "https://static.tgju.org/images/iwmf-3.png"
                },
                "webpush": {
                    "fcm_options": {
                        "link": "https://dummypage.com"
                    }
                }
            }, {
                headers: {
                    Authorization: "key=" + Env.get('firebaseserverkey')
                }
            });

        });



        return "send ok";

    }
}

module.exports = UserController
