'use strict'

const Token = use('App/Models/Token');
const User = use('App/Models/User');
const Request=use('App/Models/Request');
const DistanceController=use('App/Controllers/Http/DistanceController');

const ServicePricing=use('App/Models/ServicePricing');
const UserAddress=use('App/Models/UserAddress');

const UserFirebaseToken = use('App/Models/UserFirebaseToken');
const UserMessage = use('App/Models/UserMessage');

const axios =require('axios');
const Env = use('Env');

const UserWalletManagerController=use('App/Controllers/Http/UserWalletManagerController');

class ClientController {
  constructor({socket,io}){

    console.log('salam mahjava');

    this.socket=socket;
    this.io=io;

    var self=this;
    setInterval(function(){
      self.socket.emit('keepalive');
      // console.log('keepalive');
    },3000)
  

  }

  async sendCloudMessage(title,body,user){

    var uft= await UserFirebaseToken.query().where('user_id','=',user).orderBy('id','desc').fetch();

    uft = uft.toJSON();

    var um=new UserMessage;
    um.user_id=user;
    um.title=title;
    um.message=body;

    await um.save();

    console.log(Env.get('firebaseserverkey'));



    var fbskey=Env.get('firebaseserverkey');

   
    uft.forEach(async function(element) {

      console.log(fbskey);
      console.log("\r\n");
      console.log(element.token);

      try{
        axios.defaults.headers.common["A"]="A";
        axios.defaults.headers.common["Authorization"] = "key=AAAAkfGWmkA:APA91bHc0i6UBtgihjpiKxP76xu7-fR3OZeOizjYW548vFq51fBcUUEP0o3a3iY4-kbkBG1lQtjzRyZSxsT5RhjwrC6nsB5x6oggH0Zk1BHnDV21z-toGcV5rAM7x2YxCvbPwBLO5pf8"
        axios.defaults.headers.post["Content-Type"] = "application/json"
  
        await axios.post('https://fcm.googleapis.com/fcm/send', {
        "content_available": true,
        "mutable_content": true,
        "priority":"high",
        "data" : {
             "imageURL": "https://static.tgju.org/images/iwmf-3.png",
             "app": "1.0",
             "syntax": "swift",
             "type": "notic",
             "source": {
                 "storyboardID": "TESTVC",
                 "message": "<TESTMESSAGE>",
                 "duration": 0
             }
        },
        "to": element.token,
       "notification": {
             "title": title,
             "body": body,
             "sound": "default",
             "badge": 1,
             "icon":"https://static.tgju.org/images/iwmf-3.png"
       },
       "webpush": {
             "fcm_options": {
               "link": "https://dummypage.com"
             }
           }
 });

 // "comment_click_action": "https://aloapp.com",
//  "click_action":"blog",
//  "url":"https://aloapp.com",


//  {
//   headers:{
//       "Authorization":("key="+fbskey),
//       "Content-Type":"application/json"
//   }
// }
    console.log('ok');
  }catch(e){
    console.log("error 102");
    console.log(e);
  }

    console.log( {headers:{
      Authorization:("key="+fbskey)
  }});
       
    });

    

   return "send ok";
    
}


  async login(usertoken){
    var token=await Token.query().where('token','=',usertoken).first();
    var user=null;
    if(token!=null)
        user=await User.find(token.user_id);
    
    return user;
  }

  async newMessage(data){
    console.log('newMessage:'+data)
    this.socket.broadcast.emit('new message', {
      username: this.socket.username,
      message: data
    });
  }

  async removerequest(data){
    console.log("=== removerequest ===")
    var token=await Token.query().where('token','=',data.token).first();
    var user=null;
    if(token!=null)
        user=await User.find(token.user_id);

    console.log(data.request_id);
    console.log(user.id);
        
    var re=await Request.query().where('id','=',data.request_id).where('user_id','=',user.id).where('status','=','request').first();
    console.log(re);
    re.status='cancel';
    await re.save();
    

  }



  async clientHomeVisit(data){

    var sp= await ServicePricing.query().where('title','=','ویزیت در منزل').first();
    var price =sp.price;
    var usertoken=data.token;
    delete data.token;
    var token=await Token.query().where('token','=',usertoken).first();
    var user=null;
    if(token!=null)
        user=await User.find(token.user_id);
    var Balance=await user.wallet().getSum('amount')
    if(Balance<price){
    this.socket.emit('new message',{
      username:' مدیر مالی ',
      message:'موجودی شما = '+Balance + 'تومان'  
    })


    return this.socket.emit('new message',{
      username:' مدیر سیستم ',
      message:'برای دریافت این خدمت باید '+price+' تومان موجودی داشته باشید' 

    })
    }

    if(user==null){
      return socket.broadcast.emit('new message', {
        username: socket.username,
        message: 'error line 80.  access denied client'
      });
    }
    var geo=new DistanceController;
    var dt=geo.distance(data.latitude,data.longitude,35.7454892,51.3732133);
    var dtonline= await geo.onlinedistance(data.latitude,data.longitude,35.7454892,51.3732133);

    this.socket.emit('new message',{
      username:' مسافت سنج ',
      message:'فاصله هوایی از برج میلاد = '+dt 
    })

    this.socket.emit('new message',{
      username:' مسافت سنج ',
      message:'فاصله  از برج میلاد = '+dtonline

    })
    var userrequest=new Request;
    userrequest.user_id=user.id;
    userrequest.status='request';
    userrequest.therapist_id =null;
    userrequest.serivce='clienthomevisit';
    userrequest.extra=null;
    userrequest.price=price;
    userrequest.description=data.description;
    var ua=await UserAddress.query().where('uuid','=', data.addressuuid).where('user_id','=',user.id).first();
    userrequest.user_address_id=ua.id;
    try{
    await userrequest.save();
    }
    catch(e){
      return socket.broadcast.emit('new message', {
        username: socket.username,
        message: 'error line 101. '+e
      });
    }

    let uwm=new UserWalletManagerController;
    await uwm.Decrease(user.id,userrequest.price,'request',userrequest.id,'کسر مبلغ '+userrequest.price+' تومان بابت درخواست ویزیت در منزل');
    
    await this.sendCloudMessage('مالی','کسر مبلغ '+userrequest.price+' تومان بابت درخواست ویزیت در منزل',user.id);

    data.request_id=userrequest.id;  
    data.description=data.description;
    data.price=price;
    data.therapist='doctors';
    data.type='clienthomevisit';
    // this.socket.broadcast.emit('new message', {
    //   username: this.socket.username,
    //   message: JSON.stringify(data)
    // });

    this.io.to('ready').emit('clienthomevisit', {
      username: this.socket.username,
      message: data,
      request_id:data.request_id,
      address:ua,
      user:{
        mobile:user.mobile,
        fullname:user.fullname,
      }
    });

    this.socket.emit('clienthomevisit',{
      username: this.socket.username,
      message: data,
      request_id:data.request_id,
      address:ua,
     
    })

  }

  async clientHealthCertificate(data){

    var sp= await ServicePricing.query().where('title','=','گواهی سلامت دانش آموز').first();
    var price =sp.price;
    var usertoken=data.token;
    delete data.token;
    var token=await Token.query().where('token','=',usertoken).first();
    var user=null;
    if(token!=null)
        user=await User.find(token.user_id);
    var Balance=await user.wallet().getSum('amount')
    if(Balance<price){
    this.socket.emit('new message',{
      username:' مدیر مالی ',
      message:'موجودی شما = '+Balance + 'تومان'  
    })
    return this.socket.emit('new message',{
      username:' مدیر سیستم ',
      message:'برای دریافت این خدمت باید '+price+' تومان موجودی داشته باشید' 

    })
    }

    if(user==null){
      return socket.broadcast.emit('new message', {
        username: socket.username,
        message: 'error line 80.  access denied client'
      });
    }
    var geo=new DistanceController;
    var dt=geo.distance(data.latitude,data.longitude,35.7454892,51.3732133);
    var dtonline= await geo.onlinedistance(data.latitude,data.longitude,35.7454892,51.3732133);

    this.socket.emit('new message',{
      username:' مسافت سنج ',
      message:'فاصله هوایی از برج میلاد = '+dt 
    })

    this.socket.emit('new message',{
      username:' مسافت سنج ',
      message:'فاصله  از برج میلاد = '+dtonline

    })
    var userrequest=new Request;
    userrequest.user_id=user.id;
    userrequest.status='request';
    userrequest.therapist_id =null;
    userrequest.serivce='clienthealthcertificate';
    userrequest.extra=null;
    userrequest.price=price;
    var ua=await UserAddress.query().where('uuid','=', data.addressuuid).where('user_id','=',user.id).first();
    userrequest.user_address_id=ua.id;

    try{
    await userrequest.save();
    }
    catch(e){
      return socket.emit('new message', {
        username: socket.username,
        message: 'error line 101. '+e
      });
    }

    let uwm=new UserWalletManagerController;
    await uwm.Decrease(user.id,userrequest.price,'request',userrequest.id,'کسر مبلغ '+userrequest.price+' تومان بابت درخواست  	گواهی سلامت دانش آموز');
    await this.sendCloudMessage('مالی','کسر مبلغ '+userrequest.price+' تومان بابت درخواست  	گواهی سلامت دانش آموز',user.id);
    data.request_id=userrequest.id;  
    data.description='گواهی سلامت دانش آموز';
    var ua=await UserAddress.query().where('uuid','=', data.addressuuid).where('user_id','=',user.id).first();
    userrequest.user_address_id=ua.id;
    data.price=price;
    data.therapist='doctors';
    data.type='clienthealthcertificate';
    // this.socket.broadcast.emit('new message', {
    //   username: this.socket.username,
    //   message: JSON.stringify(data)
    // });

    this.io.to('ready').emit('clienthealthcertificate', {
      username: this.socket.username,
      message: data,
      request_id:data.request_id,
      address:ua,
      user:{
        mobile:user.mobile,
        fullname:user.fullname,
      }
    });

   

  }

  async clientDeathCertificate(data){

    var sp= await ServicePricing.query().where('title','=','گواهی فوت').first();
    var price =sp.price;
    var usertoken=data.token;
    delete data.token;
    var token=await Token.query().where('token','=',usertoken).first();
    var user=null;
    if(token!=null)
        user=await User.find(token.user_id);
    var Balance=await user.wallet().getSum('amount')
    if(Balance<price){
    this.socket.emit('new message',{
      username:' مدیر مالی ',
      message:'موجودی شما = '+Balance + 'تومان'  
    })
    return this.socket.emit('new message',{
      username:' مدیر سیستم ',
      message:'برای دریافت این خدمت باید '+price+' تومان موجودی داشته باشید' 

    })
    }

    if(user==null){
      return socket.broadcast.emit('new message', {
        username: socket.username,
        message: 'error line 80.  access denied client'
      });
    }
    var geo=new DistanceController;
    var dt=geo.distance(data.latitude,data.longitude,35.7454892,51.3732133);
    var dtonline= await geo.onlinedistance(data.latitude,data.longitude,35.7454892,51.3732133);

    this.socket.emit('new message',{
      username:' مسافت سنج ',
      message:'فاصله هوایی از برج میلاد = '+dt 
    })

    this.socket.emit('new message',{
      username:' مسافت سنج ',
      message:'فاصله  از برج میلاد = '+dtonline

    })
    var userrequest=new Request;
    userrequest.user_id=user.id;
    userrequest.status='request';
    userrequest.therapist_id =null;
    userrequest.serivce='clientdeathcertificate';
    userrequest.extra=null;
    userrequest.price=price;
    var ua=await UserAddress.query().where('uuid','=', data.addressuuid).where('user_id','=',user.id).first();
    userrequest.user_address_id=ua.id;
    try{
    await userrequest.save();
    }
    catch(e){
      return socket.emit('new message', {
        username: socket.username,
        message: 'error line 101. '+e
      });
    }

    let uwm=new UserWalletManagerController;
    await uwm.Decrease(user.id,userrequest.price,'request',userrequest.id,'کسر مبلغ '+userrequest.price+' تومان بابت درخواست  	گواهی فوت ');
    await this.sendCloudMessage('مالی','کسر مبلغ '+userrequest.price+' تومان بابت درخواست  	گواهی فوت ',user.id);
    data.request_id=userrequest.id;  
    data.description='گواهی فوت';
    var ua=await UserAddress.query().where('uuid','=', data.addressuuid).where('user_id','=',user.id).first();
    userrequest.user_address_id=ua.id;
    data.price=price;
    data.therapist='doctors';
    data.type='clientdeathcertificate';
    // this.socket.broadcast.emit('new message', {
    //   username: this.socket.username,
    //   message: JSON.stringify(data)
    // });

    this.io.to('ready').emit('clientdeathcertificate', {
      username: this.socket.username,
      message: data,
      request_id:data.request_id,
      address:ua,
      user:{
        mobile:user.mobile,
        fullname:user.fullname,
      }
    });

  }
}

module.exports = ClientController
