'use strict'
const Drugstore = use('App/Models/Drugstore');
const Cryptr = require('cryptr');
const cryptr = new Cryptr('mahjava');
const Prescription = use('App/Models/Prescription');
var Kavenegar = require('kavenegar');
const Env = use('Env');
class DrugStoreController {
  constructor({ socket, io }) {
    console.log('make socket drugstore');
    this.socket = socket
    this.io = io
    var selfdrugstore=this;
    this.socket.on('join to drugstore',async function(data){
      console.log(data);
      var ds=await selfdrugstore.login(data.token);
      console.log(ds);
      if(ds!=null){
        selfdrugstore.socket.drugid=ds.id;
        selfdrugstore.socket.druguser=ds.mobile;


        selfdrugstore.socket.join('ready drugstore');
        selfdrugstore.io.to('ready drugstore').emit('new message',{
          username:selfdrugstore.socket.druguser,
          message:'join  drugstore',
        })
      }

    });


    this.socket.on('leave drugstore',async function(data){
      selfdrugstore.socket.leave('ready drugstore');
      selfdrugstore.socket.emit('new message',{
        username:selfdrugstore.socket.druguser,
        message:'leave  drugstore',
      })
    })

    this.socket.on('accept order',async function(data){

      var ds=await selfdrugstore.login(data.token);
     

      if(ds!=null){
        var myps=await Prescription.query().whereNull('therapist_drogstore_id').where('status','=','request').where('id','=',data.id).where('created_at','=',data.created_at).first();
        console.log("====  myps  ====")
        console.log(myps);
        myps.therapist_drogstore_id=ds.id;
       
        myps.status='accept';
        
        await myps.save();

        var user = await myps.user().fetch();
        selfdrugstore.io.to('private_client_' + user.mobile).emit('nextstatus', {
          request: myps
        });
        selfdrugstore.io.to('ready drugstore').emit('accept order',{
          username:selfdrugstore.socket.druguser,
          message:myps,
        })

      }

    })

    this.socket.on('set order price',async function(data){
      var ds=await selfdrugstore.login(data.token);
      if(ds!=null){
      var myps=await Prescription.query().where('therapist_drogstore_id','=',ds.id).where('status','=','accept').where('id','=',data.id).where('created_at','=',data.created_at).first();
      myps.status='unpaid';
      myps.price=data.price;
      await myps.save();
      var user = await myps.user().fetch();
      selfdrugstore.io.to('private_client_' + user.mobile).emit('nextstatus', {
          request: myps
        });
      selfdrugstore.socket.emit('set order price',{...myps});


    }
    });


    this.socket.on('set done',async function(data){
      var ds=await selfdrugstore.login(data.token);
      if(ds!=null){
        var myps=await Prescription.query().where('therapist_drogstore_id','=',ds.id).where('status','=','paid').where('id','=',data.id).where('created_at','=',data.created_at).first();
        myps.status='done';
        await myps.save();

        var user = await myps.user().fetch();
        var api = Kavenegar.KavenegarApi({
          apikey: Env.get('Kavenegar')
        });
        console.log(user.mobile);
        api.VerifyLookup({
          token: 'دارو',
          template: 'appEndProcess',
          receptor: user.mobile,
        },
          function (response, status) {
            console.log("\r\n");
            console.log(" ===  103 ====");
            console.log("\r\n");
            console.log(response);
            console.log(status);
          });

       
        selfdrugstore.io.to('private_client_' + user.mobile).emit('nextstatus', {
            request: myps
          });
        selfdrugstore.socket.emit('set done',{...myps});

      }
    });

  }


  async login(token){

    var myarray= token.split("==");
    var mobile=myarray[0];
    var hash=myarray[1];
    var ds=await Drugstore.query().where('mobile','=',mobile).where('password','=', cryptr.decrypt(hash)).first();
    return ds;

  }
}

module.exports = DrugStoreController
