'use strict'
const Helpers = use('Helpers')
const mkdirp = require('mkdirp');

class FileManagerController {
  constructor({ socket, io }) {
    this.socket = socket;
    this.io = io;
    this.files = {},
      this.struct = {
        name: null,
        type: null,
        size: 0,
        data: [],
        slice: 0,
      };
    this.fs= require('fs');


    var filemanager = this;

    this.socket.on('slice upload', async (data) => {
      if (!filemanager.files[data.name]) {
        filemanager.files[data.name] = Object.assign({}, filemanager.struct, data);
        filemanager.files[data.name].data = [];
      }

      //convert the ArrayBuffer to Buffer 
      data.data = new Buffer(data.data);
      // data.data = new Buffer(new Uint8Array(data.data));
      
      //save the data 
      filemanager.files[data.name].data.push(data.data);
      filemanager.files[data.name].slice++;

      if (filemanager.files[data.name].slice * 20000 >= filemanager.files[data.name].size) {

        console.log(filemanager.files[data.name])

        console.log("\r\n");
        console.log("\r\n");
        console.log("\r\n");
        console.log(Helpers.publicPath('/uploads/prescription/therapist/'+socket.username+'/'));
        if (!filemanager.fs.existsSync(Helpers.publicPath('/uploads/prescription/therapist/'+socket.username))) {
           filemanager.fs.mkdirSync(Helpers.publicPath('/uploads/prescription/therapist/'+socket.username),{ recursive: true });
        }
        
        console.log("\r\n");
        console.log("\r\n");
        var n=Date.now();
        var pathfile=Helpers.publicPath('/uploads/prescription/therapist/'+socket.username+'/'+n+data.name);

        filemanager.files[data.name].data.forEach(async function(d){
          console.log("\r\n");
          console.log(d);
          console.log("\r\n");

          await filemanager.fs.appendFileSync(pathfile, d, 'binary');
        });

      
        //do something with the data 
        filemanager.socket.emit('end upload');
        filemanager.socket.emit('new message',{username:socket.username,message:'<img width="320" src="/uploads/prescription/therapist/'+socket.username+'/'+n+data.name+'"/>'});
      } else {
        console.log('request slice upload');
        filemanager.socket.emit('request slice upload', {
          currentSlice: filemanager.files[data.name].slice
        });
      }
    });
  }
}

module.exports = FileManagerController
