'use strict'
const LaboratoryInstruction = use('App/Models/LaboratoryInstruction');
const ServicePricing=use ('App/Models/ServicePricing');
const ServiceCategory =use ('App/Models/ServiceCategory');
const Helpers = use('Helpers');
const mkdirp = require('mkdirp');
const UserAddress = use('App/Models/UserAddress');

const UserWalletManagerController=use('App/Controllers/Http/UserWalletManagerController');

class LaboratoryInstructionsManagerController {
  constructor({ socket, io ,$client}) {
    this.socket = socket;
    this.io = io;
    this.clienttoken=null;
    this.userclient=null;
    this.request_id=null; 
    this.description=null;
    this.insurance_id=null;
    this.extra=null,
    this.user_address_id=null;
    this.attachfilenumer=1;
    this.sans_id=null,
    this.sans_date=null,
    this.files = {},
      this.struct = {
        name: null,
        type: null,
        size: 0,
        data: [],
        slice: 0,
      };
    this.$client=$client;  
    this.fs= require('fs');
    var filemanager = this;

    this.socket.on('LaboratoryInstructions client create', async (data)=>{
        console.log("\r\n 26")
        filemanager.userclient=await filemanager.$client.login(data.token);
        console.log(filemanager.userclient);
        if(filemanager.userclient!=null){
          filemanager.clienttoken=data.token;
         
          this.clienttoken=data.token;
          this.description=data.description;
          this.insurance_id=data.insurance_id;
          this.extra=data.extra;
          this.request_id=null;
          if(typeof data.attachfilenumer !='undefined'){
            this.attachfilenumer=data.attachfilenumer;

          }
          this.sans_id=data.sans_id;
          this.sans_date=data.sans_date;


          console.log("\r\n");
          console.log("=== address uuid ===");
          console.log("\r\n");
          console.log( data.addressuuid);
          var ua=await UserAddress.query().where('uuid','=', data.addressuuid).where('user_id','=',filemanager.userclient.id).first();
          
          filemanager.user_address_id=ua.id;
          console.log(ua);
          filemanager.socket.emit('LaboratoryInstructions log','create base LaboratoryInstructions.should send file');
        }else{
          filemanager.socket.emit('LaboratoryInstructions log','user not valid token');
        }
        
    });

    this.socket.on('LaboratoryInstructions null image',async ()=>{
    var Balance=await filemanager.userclient.wallet().getSum('amount');
    var price=await ServicePricing.query().whereIn('id',filemanager.extra).getSum('price');;
    if(Balance<price){
    this.socket.emit('new message',{
      username:' مدیر مالی ',
      message:'موجودی شما = '+Balance + 'تومان'  
    })
    return this.socket.emit('new message',{
      username:' مدیر سیستم ',
      message:'برای دریافت این خدمت باید '+price+' تومان موجودی داشته باشید' 

    })
    }else{
      var li=new LaboratoryInstruction;
      li.user_id=filemanager.userclient.id;
      li.status='request';
      li.image=null;
      li.price=price;
      li.insurance_id=filemanager.insurance_id;
      li.description=filemanager.description;

      li.extra=JSON.stringify(filemanager.extra);
      li.request_id=filemanager.request_id;
      li.user_address_id=filemanager.user_address_id;
      li.sans_id=filemanager.sans_id;
     
      li.sans_date= new Date(filemanager.sans_date);

      console.log(li);
      try{
      await li.save();
      }catch(e){
        console.log(e);
      }
      console.log("\r\n 51")

      let uwm=new UserWalletManagerController;
      await uwm.Decrease(filemanager.userclient.id,price,'sampling',li.id,'کسر مبلغ '+price+'درخواست آزمایش بدون نسخه');
      li.status='paid';
      await li.save();


      filemanager.socket.emit('LaboratoryInstructions client end upload',{id:li.id,attachfilenumer:filemanager.attachfilenumer});
      console.log('116');

    }

    
    });




    this.socket.on('LaboratoryInstructions client slice upload', async (data) => {
      if (!filemanager.files[data.name]) {
        filemanager.files[data.name] = Object.assign({}, filemanager.struct, data);
        filemanager.files[data.name].data = [];
      }

      //convert the ArrayBuffer to Buffer 
      data.data = new Buffer(data.data);
      // data.data = new Buffer(new Uint8Array(data.data));
      
      //save the data 
      filemanager.files[data.name].data.push(data.data);
      filemanager.files[data.name].slice++;

      if (filemanager.files[data.name].slice * 20000 >= filemanager.files[data.name].size) {

        console.log(filemanager.files[data.name])

        console.log("\r\n");
        console.log("\r\n");
        console.log("\r\n");
        console.log(Helpers.publicPath('/uploads/LaboratoryInstructions/client/'+filemanager.userclient.mobile+'/'));
        if (!filemanager.fs.existsSync(Helpers.publicPath('/uploads/LaboratoryInstructions/client/'+filemanager.userclient.mobile))) {
           filemanager.fs.mkdirSync(Helpers.publicPath('/uploads/LaboratoryInstructions/client/'+filemanager.userclient.mobile),{ recursive: true });
        }
        
        console.log("\r\n");
        console.log("\r\n");
        var n=Date.now();
        var pathfile=Helpers.publicPath('/uploads/LaboratoryInstructions/client/'+filemanager.userclient.mobile+'/'+n+data.name);

        console.log(data.name);
        filemanager.files[data.name].data.forEach(async function(d){
          console.log("\r\n");
          console.log(d);
          console.log("\r\n");

          await filemanager.fs.appendFileSync(pathfile, d, 'binary');
         


        });
        console.log("\r\n 99")
        var price=await ServicePricing.query().whereIn('id',filemanager.extra).getSum('price');;
        var li=new LaboratoryInstruction;
        li.user_id=filemanager.userclient.id;
        li.status='request';
        li.image='/uploads/LaboratoryInstructions/client/'+filemanager.userclient.mobile+'/'+n+data.name;
        li.insurance_id=filemanager.insurance_id;
        li.description=filemanager.description;
        li.extra=JSON.stringify(filemanager.extra);
        li.price=price;
        li.request_id=filemanager.request_id;
        li.user_address_id=filemanager.user_address_id;
        li.sans_id=filemanager.sans_id;
        li.sans_date= new Date(filemanager.sans_date);
        
        console.log("\r\n 107")
        await li.save();


        delete filemanager.files[data.name];

      
        //do something with the data 
        filemanager.socket.emit('LaboratoryInstructions client end upload',{id:li.id,attachfilenumer:filemanager.attachfilenumer});
        console.log("\r\n 170")

        filemanager.socket.emit('new message',{username:filemanager.userclient.mobile,message:'<img width="320" src="/uploads/LaboratoryInstructions/client/'+socket.username+'/'+n+data.name+'"/>'});
      } else {
        console.log('LaboratoryInstructions client request slice upload');
        filemanager.socket.emit('LaboratoryInstructions client request slice upload', {
          currentSlice: filemanager.files[data.name].slice
        });
      }
    });


    this.socket.on('LaboratoryInstructions client slice two upload', async (data) => {

      if (!filemanager.files[data.name]) {
        filemanager.files[data.name] = Object.assign({}, filemanager.struct, data);
        filemanager.files[data.name].data = [];
      }

      //convert the ArrayBuffer to Buffer 
      data.data = new Buffer(data.data);
      // data.data = new Buffer(new Uint8Array(data.data));
      
      //save the data 
      filemanager.files[data.name].data.push(data.data);
      filemanager.files[data.name].slice++;

      if (filemanager.files[data.name].slice * 20000 >= filemanager.files[data.name].size) {

        console.log(filemanager.files[data.name])

        console.log("\r\n");
        console.log("\r\n");
        console.log("\r\n");
        console.log(Helpers.publicPath('/uploads/LaboratoryInstructions/client/'+filemanager.userclient.mobile+'/'));
        if (!filemanager.fs.existsSync(Helpers.publicPath('/uploads/LaboratoryInstructions/client/'+filemanager.userclient.mobile))) {
           filemanager.fs.mkdirSync(Helpers.publicPath('/uploads/LaboratoryInstructions/client/'+filemanager.userclient.mobile),{ recursive: true });
        }
        
        console.log("\r\n");
        console.log("\r\n");
        var n=Date.now();
        var pathfile=Helpers.publicPath('/uploads/LaboratoryInstructions/client/'+filemanager.userclient.mobile+'/'+n+data.name);

        console.log(data.name);
        filemanager.files[data.name].data.forEach(async function(d){
          console.log("\r\n");
          console.log(d);
          console.log("\r\n");

          await filemanager.fs.appendFileSync(pathfile, d, 'binary');
         


        });
        console.log("\r\n 99")

        console.log(data.laboratory_instruction_id);

     
        var li=await LaboratoryInstruction.query().where('id','=',data.laboratory_instruction_id).first();


        //console.log(typeof li);


     
        li.status='request';
        li.image+=("\r\n"+'/uploads/LaboratoryInstructions/client/'+filemanager.userclient.mobile+'/'+n+data.name);
        console.log(li.image);
       
        await li.save();


        delete filemanager.files[data.name];

      
        //do something with the data 
        filemanager.socket.emit('LaboratoryInstructions client two end upload',{id:li.id,attachfilenumer:filemanager.attachfilenumer});
        console.log("\r\n 249")

        filemanager.socket.emit('new message',{username:socket.username,message:'<img width="320" src="/uploads/LaboratoryInstructions/client/'+socket.username+'/'+n+data.name+'"/>'});
      } else {
        console.log('LaboratoryInstructions client request slice two upload');
        filemanager.socket.emit('LaboratoryInstructions client request slice two upload', {
          currentSlice: filemanager.files[data.name].slice,
          id:data.laboratory_instruction_id,
          attachfilenumer:filemanager.attachfilenumer,
        });
      }

    });
  
  }
}

module.exports = LaboratoryInstructionsManagerController
