'use strict'
const Database = use('Database');
const Therapist = use('App/Models/Therapist');
const Request = use('App/Models/Request');
const LaboratoryInstruction = use('App/Models/LaboratoryInstruction');
const Prescription = use('App/Models/Prescription');
const Helpers = use('Helpers');
var Kavenegar = require('kavenegar');
const Env = use('Env');

const TherapistWalletManagerController = use('App/Controllers/Http/TherapistWalletManagerController');

class TherapistController {
  constructor({ socket, io, $client }) {
    console.log('open therapist manager');
    this.socket = socket;
    this.io = io;
    this.$client = $client;
    this.files = {},
      this.struct = {
        name: null,
        type: null,
        size: 0,
        data: [],
        slice: 0,
      };
    this.laboratory = [];
    this.prescriptions = [];
    this.fs = require('fs');
  }

  async CalculateTheCommission(therapist, price) {

    console.log('CalculateTheCommission')
    console.log(price)

    if (therapist.type == 'doctor') {

      return (price / 100) * 95;

    } else {
      return (price / 100) * 50;
    }


  }


  async join(data) {

    var therapist = await Therapist.query().where('token', '=', data.token).first();
    if (therapist == null) {
      this.socket.emit('error', { code: "403", error: true, message: "اهراز هویت انجام نشد" });
    }

    return therapist;

  }

  async nextstatus(data) {
    var therapist = await this.login(data.token);
    if (therapist == null) {
      return this.socket.emit('error', { code: "403", error: true, message: "اهراز هویت انجام نشد" });
    }

    if (therapist.type == 'doctor' || therapist.type == 'nurse' || therapist.type == 'midwife') {
      var serivcevalid = ['clienthomevisit', 'clienthealthcertificate', 'clientdeathcertificate', 'nurse', 'midwife']
    } else {
      var serivcevalid = [];

    }

    var farsistatus = 'در مسیر';

    var request = await Request.query().where('id', '=', data.request_id).whereIn('status', ['accept', 'onway', 'doing']).where('therapist_id', '=', therapist.id).whereIn('serivce', serivcevalid).with('user').with('therapist').with('therapist.detail').with('address').first();
    if (request != null) {
      switch (request.status) {
        case 'accept':
          request.status = 'onway';
          break;
        case 'onway':
          request.status = 'doing';
          farsistatus = 'در حال انجام'
          break;
        case 'doing':
          request.status = 'done';
          farsistatus = 'انجام شده';
          console.log('line 67');
          try {

            var mytoken='پزشک';

            if(request.serivce=='nurse'){
               mytoken='پرستار';
            }

            if(request.serivce=='midwife'){
               mytoken='ماما';
            }

            



            var user = await request.user().fetch();
            var api = Kavenegar.KavenegarApi({
              apikey: Env.get('Kavenegar')
            });
            console.log(user.mobile);
            api.VerifyLookup({
              token: mytoken,
              template: 'appEndProcess',
              receptor: user.mobile,
            },
              function (response, status) {
                console.log("\r\n");
                console.log(" ===  103 ====");
                console.log("\r\n");
                console.log(response);
                console.log(status);
              });
          } catch (e) {
            console.log("\r\n");
            console.log(" ===  111 ====");
            console.log("\r\n");
            console.log(e);
          }

          var ctcp = await this.CalculateTheCommission(therapist, request.price);
          let twm = new TherapistWalletManagerController;
          await twm.Increase(therapist.id, ctcp, 'done request', request.id, 'افزایش مبلغ ' + ctcp + ' بابت انجام   کار');
          break;
      }

      console.log(request.status);

      await request.save();

      await this.$client.sendCloudMessage('تغییر وضعیت درخواست', 'درخواست شما به وضعیت ' + farsistatus + ' تغییر یافت', request.user_id);



      this.socket.emit('new message', {
        username: 'سیستم',
        message: 'تغییر وضعیت انجام شد'
      })

      var user = await request.user().fetch();
      console.log('private_client_' + user.mobile);
      console.log({
        username: 'سیستم',
        message: 'وضعیت درخواست شما تغییر کرد',
      });


      this.io.to('private_client_' + user.mobile).emit('new message', {
        username: 'سیستم',
        message: 'وضعیت درخواست شما تغییر کرد',
      });


      this.io.to('private_client_' + user.mobile).emit('nextstatus', {
        request: request
      });

    } else {
      this.emit('new message', {
        username: 'سیستم',
        message: 'تغییر وضعیت انجام نشد'
      })
    }
  }

  async changeLocation(data) {
    var therapist = await this.login(data.token);
    if (therapist == null) {
      return this.socket.emit('error', { code: "403", error: true, message: "اهراز هویت انجام نشد" });
    }

    await Therapist.query().where('id','=',therapist.id).update({
      latitude:data.latitude,
      longitude:data.longitude,
    });
    


    delete data.token;

    return this.io.to('private_client_' + data.mobile).emit('change-location', data);



  }


  async accept(data) {

    var therapist = await this.login(data.token);
    if (therapist == null) {
      return this.socket.emit('error', { code: "403", error: true, message: "اهراز هویت انجام نشد" });
    }


    var request;

    await Database.transaction(async (trx) => {


      if (therapist.type == 'doctor' || therapist.type == 'nurse' || therapist.type == 'midwife') {
        var serivcevalid = ['clienthomevisit', 'clienthealthcertificate', 'clientdeathcertificate', 'nurse', 'midwife']
      } else {
        var serivcevalid = [];

      }

      request = await Request.query().where('id', '=', data.request_id).whereIn('status', ['request', 'paid']).whereIn('serivce', serivcevalid).first();


      if (request != null) {

        request.status = 'accept';
        request.therapist_id = therapist.id;



        await request.save();

        await this.$client.sendCloudMessage('تایید درخواست', 'درخواست شما مورد تایید قرار گرفت', request.user_id);

        try {
          var api = Kavenegar.KavenegarApi({
            apikey: Env.get('Kavenegar')
          });
          var user = await request.user().fetch();
          console.log(user.mobile);
          api.VerifyLookup({
            token: 'تاییدشده',
            token2:(therapist.name+'_'+therapist.lastname).replace(/ /g,'_'),
            token3:therapist.mobile,
            template: 'requestAcceptedNotif',
            receptor: user.mobile,
          },
            function (response, status) {
              console.log("\r\n");
              console.log(" ===  223 ====");
              console.log("\r\n");
              console.log(response);
              console.log(status);
            });
        } catch (e) {
          console.log("\r\n");
          console.log(" ===  231 ====");
          console.log("\r\n");
          console.log(e);
        }





        request = await Request.query().where('id', '=', request.id).where('status', '=', 'accept').with('user').with('therapist').with('therapist.detail').with('address').first();

        var user = await request.user().fetch();
        console.log('private_client_' + user.mobile);
        console.log({
          username: 'سیستم',
          message: 'وضعیت درخواست شما تغییر کرد',
        });


        this.io.to('private_client_' + user.mobile).emit('new message', {
          username: 'سیستم',
          message: 'وضعیت درخواست شما تغییر کرد',
        });


        this.io.to('private_client_' + user.mobile).emit('nextstatus', {
          request: request
        });

        this.socket.emit('accept', {
          request: request
        });

      }



    });


    if (request == null) {
      return this.socket.broadcast.emit('new message', {
        username: this.socket.username,
        message: 'درخواست قبل از شما توسط پزشک دیگری تایید شده است'
      })
    }








    var person = await therapist.person();

    this.socket.broadcast.emit('new message', {
      username: this.socket.username,
      message: JSON.stringify({
        accept: data.request_id, therapist: {
          name: therapist.name,
          lastname: therapist.lastname,
          type: therapist.type,
          mobile: therapist.mobile,
          person: {
            avatar: person.avatar,
            medical_council_code: person.medical_council_code
          }
        }
      })
    });
  }


  async login(therapisttoken) {

    var therapist = await Therapist.query().where('token', '=', therapisttoken).first();

    return therapist;



  }


  async attach(data) {

    //console.log(data.request.request_id);

    var therapist = await this.login(data.token);
    if (therapist == null) {
      return this.socket.emit('error', { code: "403", error: true, message: "اهراز هویت انجام نشد" });
    }

    data.request = await Request.query().where('id', '=', data.request.request_id).with('user').first();
    data.request = data.request.toJSON();
    //console.log(data.request);


    if (data.type == 'laboratory') {

      this.laboratory.push({

        user_id: data.request.user.id,
        status: 'register',

        insurance_id: null,
        description: data.description,



        request_id: data.request.id,

        user_address_id: data.request.user_address_id,
        therapist_id: therapist.id,

      })



      this.socket.emit('attach log', 'create base LaboratoryInstructions.should send file');

    }

    if (data.type == 'prescriptions') {

      //var li=new LaboratoryInstruction;

      this.prescriptions.push({

        user_id: data.request.user.id,
        status: 'register',

        insurance_id: null,
        description: data.description,



        request_id: data.request.id,

        user_address_id: data.request.user_address_id,
        therapist_id: therapist.id,

      })




      this.socket.emit('attach log', 'create base LaboratoryInstructions.should send file');

      console.log('324');

    }

  }

  async attachSliceUpload(data) {

    var therapist = await this.login(data.token);
    console.log(therapist);
    if (!this.files[data.name]) {
      this.files[data.name] = Object.assign({}, this.struct, data);
      this.files[data.name].data = [];
    }

    console.log('339');

    console.log(this.files[data.name].size);


    //convert the ArrayBuffer to Buffer 
    data.data = new Buffer(data.data);
    // data.data = new Buffer(new Uint8Array(data.data));

    //save the data 
    this.files[data.name].data.push(data.data);
    this.files[data.name].slice++;

    console.log(this.files[data.name].slice * 20000);
    console.log('348');
    if (this.files[data.name].slice * 20000 >= this.files[data.name].size) {
      console.log('350');
      console.log(this.files[data.name])

      console.log("\r\n");
      console.log("\r\n");
      console.log("\r\n");
      console.log(Helpers.publicPath('/uploads/LaboratoryInstructions/client/' + therapist.mobile + '/'));
      if (!this.fs.existsSync(Helpers.publicPath('/uploads/LaboratoryInstructions/client/' + therapist.mobile))) {
        this.fs.mkdirSync(Helpers.publicPath('/uploads/LaboratoryInstructions/client/' + therapist.mobile), { recursive: true });
      }

      console.log("\r\n");
      console.log("\r\n");
      var n = Date.now();
      var pathfile = Helpers.publicPath('/uploads/LaboratoryInstructions/client/' + therapist.mobile + '/' + n + data.name);
      console.log('365');
      console.log(data.name);
      var self = this;
      this.files[data.name].data.forEach(async function (d) {
        console.log("\r\n");
        console.log(d);
        console.log("\r\n");

        console.log(pathfile);


        await self.fs.appendFileSync(pathfile, d, 'binary');



      });
      console.log("\r\n 99")

      var llll;

      if (data.datatype == 'laboratory') {

        llll = this.laboratory.filter(ll => ll.therapist_id = therapist.id)[0];



        var li = new LaboratoryInstruction;
        li.user_id = llll.user_id
        li.status = llll.user_id
        li.image = '/uploads/LaboratoryInstructions/client/' + therapist.mobile + '/' + n + data.name;
        li.insurance_id = llll.insurance_id
        li.description = llll.description

        li.price = 0;
        li.request_id = llll.request_id
        li.user_address_id = llll.user_address_id
        console.log("\r\n 107")
        await li.save();
        this.laboratory.filter(ll => ll.therapist_id = therapist.id)[0].therapist_id = null;

      }

      console.log('401');

      if (data.datatype == 'prescriptions') {

        llll = this.prescriptions.filter(ll => ll.therapist_id = therapist.id)[0];

        var pr = new Prescription;
        pr.user_id = llll.user_id
        pr.status = llll.user_id
        pr.image = '/uploads/LaboratoryInstructions/client/' + therapist.mobile + '/' + n + data.name;
        pr.insurance_id = llll.insurance_id
        pr.description = llll.description

        pr.price = 0;
        pr.request_id = llll.request_id
        pr.user_address_id = llll.user_address_id
        console.log("\r\n 107")
        await pr.save();
        this.prescriptions.filter(ll => ll.therapist_id = therapist.id)[0].therapist_id = null;
      }


      delete this.files[data.name];
      console.log('424');

      //do something with the data 
      this.socket.emit('attach request end upload');
      console.log("\r\n 113")

      this.socket.emit('new message', { username: this.socket.username, message: '<img width="320" src="/uploads/LaboratoryInstructions/client/' + this.socket.username + '/' + n + data.name + '"/>' });
    } else {
      console.log('attach request slice upload');
      this.socket.emit('attach request slice upload', {
        currentSlice: this.files[data.name].slice
      });

      console.log(this.files[data.name].slice);

      console.log('437');
    }

  }
}

module.exports = TherapistController
