'use strict'
/** @typedef {import('@adonisjs/framework/src/Request')} Request */
/** @typedef {import('@adonisjs/framework/src/Response')} Response */
/** @typedef {import('@adonisjs/framework/src/View')} View */

const Therapist = use('App/Models/Therapist');

class AuthTherapist {
  /**
   * @param {object} ctx
   * @param {Request} ctx.request
   * @param {Function} next
   */
  async handle ({ request,response,params }, next) {
    // call next to advance the request

    if(typeof params.token!='undefined'){
      var t=params.token;
    }else{
      var t=request.headers().authorization
    }


    var therapist=await Therapist.query().where('token','=',t).first();

    if(therapist==null){
      return   response.send({ code: "403", error: true, message: "اهراز هویت انجام نشد" });
    }

    request.therapist=therapist.toJSON();
    
    await next()
  }
}

module.exports = AuthTherapist
