'use strict'

/** @type {typeof import('@adonisjs/lucid/src/Lucid/Model')} */
const Model = use('Model')
const Doctor = use('App/Models/Doctor');


class Therapist extends Model {


    wallet () {
        return this.hasMany('App/Models/TherapistWallet')
    }

    async person(){
       
        if(this.type=='doctor'){
            return await Doctor.find(this.type_id);
        }

        return this.type
    }

    detail(){
        if(this.type=='doctor'){
            return this.hasOne('App/Models/Doctor','type_id','id')
        }

        if(this.type=='nurse'){
            return this.hasOne('App/Models/Nurse','type_id','id')
        }

        if(this.type=='midwife'){
            return this.hasOne('App/Models/Midwife','type_id','id')
        }

        if(this.type=='laboratory'){
            return 'test';
            return this.hasOne('App/Models/Laboratory','type_id','id')
        }

        if(this.type=='drugstore'){
            return this.hasOne('App/Models/Drugstore','type_id','id')
        }

        return null;
    }
}

module.exports = Therapist
