'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class TherapistsSchema extends Schema {
  up () {
    this.create('therapists', (table) => {
      table.increments()
      table.string('mobile').unique();
      table.string('name');
      table.string('lastname');
      table.enum('type',['doctor','nurse','drugstore','laboratory']);
      table.integer('type_id');
      table.text('token');
      table.text('last_agent');
      table.string('last_ip');
      table.string('verify_code');
      table.uuid('uuid');
      
      

      table.timestamps()
    })
  }

  down () {
    this.drop('therapists')
  }
}

module.exports = TherapistsSchema
