'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class NursesSchema extends Schema {
  up () {
    this.create('nurses', (table) => {
      table.increments()
      table.integer('therapist_id').unsigned().references('id').inTable('therapists')
      table.string('medical_council_code');
      table.string('mobile');
      table.string('bank');
      table.string('account_number');
      table.string('card_number');
      table.string('sheba_number');
      table.string('avatar');
      table.string('national_code');
      table.string('contract_number');
      table.uuid('uuid');
      table.timestamps()
    })
  }

  down () {
    this.drop('nurses')
  }
}

module.exports = NursesSchema
