'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class UserWalletsSchema extends Schema {
  up () {
    this.create('user_wallets', (table) => {
      table.increments()
      table.integer('user_id').unsigned().references('id').inTable('users')
      table.integer('amount');
      table.string('type');
      table.integer('type_id');
      table.text('descriptions');
      table.text('hash');
      table.uuid('uuid');
      table.timestamps()
    })
  }

  down () {
    this.drop('user_wallets')
  }
}

module.exports = UserWalletsSchema
