'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class CommentsSchema extends Schema {
  up () {
    this.create('comments', (table) => {
      table.increments();
      table.integer('user_id').unsigned().references('id').inTable('users')
      table.integer('request_id');
      table.integer('therapist_id');
      table.text('comment');
      table.uuid('uuid');
      table.timestamps();
    })
  }

  down () {
    this.drop('comments')
  }
}

module.exports = CommentsSchema
