'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class LogsSchema extends Schema {
  up () {
    this.create('logs', (table) => {
      table.increments();
      table.integer('user_id').unsigned().references('id').inTable('users')
      table.string('type');
      table.string('description');
      table.timestamps();
    })
  }

  down () {
    this.drop('logs')
  }
}

module.exports = LogsSchema
