'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class ServicePricingsSchema extends Schema {
  up () {
    this.create('service_pricings', (table) => {
      table.increments();
      table.integer('price');
      table.string('title').unique();
      table.string('icon');
      table.integer('category_id');
      table.timestamps();
    })
  }

  down () {
    this.drop('service_pricings')
  }
}

module.exports = ServicePricingsSchema
