'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class ShopUserAddressesSchema extends Schema {
  up () {
    this.create('shop_user_addresses', (table) => {
      table.increments();
      table.integer('user_id').unsigned().references('id').inTable('users')
      table.string('name');
      table.string('tel');
      table.string('state');
      table.string('city');
      table.text('address');
      table.float('latitude');
      table.float('longitude');
      table.timestamps();
    })
  }

  down () {
    this.drop('shop_user_addresses')
  }
}

module.exports = ShopUserAddressesSchema
