'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class OrderSchema extends Schema {
  up () {
    this.create('orders', (table) => {
      table.increments()
      table.integer('user_id').unsigned().references('id').inTable('users')
      table.enum('status',['register','paid','unpaid','complete','deliver']);
      table.string('tracking_code');
      table.text('delivery_address');
      table.integer('total_price');
      table.integer('discount_price');
      table.integer('transport_price');
      table.integer('payable');
      table.timestamps()
    })
  }

  down () {
    this.drop('orders')
  }
}

module.exports = OrderSchema
