'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class RequestsSchema extends Schema {
  up () {
    this.create('requests', (table) => {
      table.increments();
      table.integer('user_id').unsigned().references('id').inTable('users')
      table.enum('status',['request','accept','onway','doing','done','cancel']);
      table.integer('therapist_id').unsigned().references('id').inTable('therapists')
      table.string('serivce');
      table.text('extra');
      table.integer('price');
      table.string('description');
      table.integer('user_address_id');
      table.timestamps();

    })
  }

  down () {
    this.drop('requests')
  }
}

module.exports = RequestsSchema
