'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class PrescriptionsSchema extends Schema {
  up () {
    this.create('prescriptions', (table) => {
     
      table.increments();
      table.integer('user_id');
      table.integer('therapist_id').nullable();
      table.integer('request_id').nullable();
      table.integer('therapist_drogstore_id');
      table.integer('price').nullable();
      table.enum('status',['register','request','accept','unpaid','paid','deliver']);
      table.string('image');
      table.text('description');
      table.integer('user_address_id').nullable().unsigned().references('id').inTable('user_addresses');

      table.integer('insurance_id').nullable();
      

      table.timestamps();
    })
  }

  down () {
    this.drop('prescriptions')
  }
}

module.exports = PrescriptionsSchema
