'use strict'

/** @type {import('@adonisjs/lucid/src/Schema')} */
const Schema = use('Schema')

class CategoriesSchema extends Schema {
  up () {
    this.create('service_categories', (table) => {
      table.increments()
      table.string('title');
      table.enum('type',['nursing','midwifery','laboratory']);
      table.string('image');
      table.timestamps()
    })
  }

  down () {
    this.drop('service_categories')
  }
}

module.exports = CategoriesSchema
