$(function () {
  var FADE_TIME = 150; // ms
  var TYPING_TIMER_LENGTH = 400; // ms
  var COLORS = [
    '#e21400', '#91580f', '#f8a700', '#f78b00',
    '#58dc00', '#287b00', '#a8f07a', '#4ae8c4',
    '#3b88eb', '#3824aa', '#a700ff', '#d300e7'
  ];

  // Initialize variables
  var $window = $(window);
  var $usernameInput = $('.usernameInput'); // Input for username
  var $messages = $('.messages'); // Messages area
  var $inputMessage = $('.inputMessage'); // Input message input box

  var $clienthomevisit = $('.client-home-visit');

  var $loginPage = $('.login.page'); // The login page
  var $chatPage = $('.chat.page'); // The chatroom page

  var $gotoroom = $('.gotoroom');

  var $onlineer = $('.onlineer');

  var $uploadprescription = $('.upload-prescription');




  // Prompt for setting a username
  var username;
  var connected = false;
  var typing = false;
  var lastTypingTime;
  var $currentInput = $usernameInput.focus();


  var publicgps = null;



  function getLocation() {
    if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition(showPosition);
    } else {
      alert("Geolocation is not supported by this browser.");
    }
  }

  function showPosition(position) {
    publicgps = { latitude: position.coords.latitude, longitude: position.coords.longitude };
    // alert( "Latitude: " + position.coords.latitude +"\r\n Longitude: " + position.coords.longitude)
  }

  var socket = io();

  const addParticipantsMessage = (data) => {
    var message = '';
    if (data.numUsers === 1) {
      message += "یک نفر در روم اشتراک دارد";
    } else {
      message += "تعداد " + data.numUsers + "نفر در روم اشتراک دارند ";
    }
    log(message);
  }

  // Sets the client's username
  const setUsername = () => {
    username = cleanInput($usernameInput.val().trim());

    // If the username is valid
    if (username) {
      $loginPage.fadeOut();
      $chatPage.show();
      $loginPage.off('click');
      $currentInput = $inputMessage.focus();

      // Tell the server your username
      socket.emit('add therapist', { token: token });
    }
  }

  // Sends a chat message
  const sendMessage = () => {
    var message = $inputMessage.val();
    // Prevent markup from being injected into the message
    message = cleanInput(message);
    // if there is a non-empty message and a socket connection
    if (message && connected) {
      $inputMessage.val('');
      addChatMessage({
        username: username,
        message: message
      });
      // tell server to execute 'new message' and send along one parameter
      socket.emit('new message', message);
    }
  }

  // Log a message
  const log = (message, options) => {
    var $el = $('<li>').addClass('log').text(message);
    addMessageElement($el, options);
  }

  // Adds the visual chat message to the message list
  const addChatMessage = (data, options) => {
    // Don't fade the message in if there is an 'X was typing'
    var $typingMessages = getTypingMessages(data);
    options = options || {};
    if ($typingMessages.length !== 0) {
      options.fade = false;
      $typingMessages.remove();
    }

    var $usernameDiv = $('<span class="username"/>')
      .text(data.username)
      .css('color', getUsernameColor(data.username));
    var $messageBodyDiv = $('<span class="messageBody">')
      .html(data.message);

    var typingClass = data.typing ? 'typing' : '';

    if (username == data.username) {
      typingClass = typingClass + ' myuser'
    }

    var $messageDiv = $('<li class="message"/>')
      .data('username', data.username)
      .addClass(typingClass)
      .append($usernameDiv, $messageBodyDiv);

    addMessageElement($messageDiv, options);
  }

  // Adds the visual chat typing message
  const addChatTyping = (data) => {
    data.typing = true;
    data.message = 'در حال تایپ';
    addChatMessage(data);
  }

  // Removes the visual chat typing message
  const removeChatTyping = (data) => {
    getTypingMessages(data).fadeOut(function () {
      $(this).remove();
    });
  }

  // Adds a message element to the messages and scrolls to the bottom
  // el - The element to add as a message
  // options.fade - If the element should fade-in (default = true)
  // options.prepend - If the element should prepend
  //   all other messages (default = false)
  const addMessageElement = (el, options) => {
    var $el = $(el);

    // Setup default options
    if (!options) {
      options = {};
    }
    if (typeof options.fade === 'undefined') {
      options.fade = true;
    }
    if (typeof options.prepend === 'undefined') {
      options.prepend = false;
    }

    // Apply options
    if (options.fade) {
      $el.hide().fadeIn(FADE_TIME);
    }
    if (options.prepend) {
      $messages.prepend($el);
    } else {
      $messages.append($el);
    }
    $messages[0].scrollTop = $messages[0].scrollHeight;
  }

  // Prevents input from having injected markup
  const cleanInput = (input) => {
    return $('<div/>').text(input).html();
  }

  // Updates the typing event
  const updateTyping = () => {
    if (connected) {
      if (!typing) {
        typing = true;
        socket.emit('typing');
      }
      lastTypingTime = (new Date()).getTime();

      setTimeout(() => {
        var typingTimer = (new Date()).getTime();
        var timeDiff = typingTimer - lastTypingTime;
        if (timeDiff >= TYPING_TIMER_LENGTH && typing) {
          socket.emit('stop typing');
          typing = false;
        }
      }, TYPING_TIMER_LENGTH);
    }
  }

  // Gets the 'X is typing' messages of a user
  const getTypingMessages = (data) => {
    return $('.typing.message').filter(function (i) {
      return $(this).data('username') === data.username;
    });
  }

  // Gets the color of a username through our hash function
  const getUsernameColor = (username) => {
    // Compute hash code
    var hash = 7;
    for (var i = 0; i < username.length; i++) {
      hash = username.charCodeAt(i) + (hash << 5) - hash;
    }
    // Calculate color
    var index = Math.abs(hash % COLORS.length);
    return COLORS[index];
  }

  // Keyboard events
  $uploadprescription.click(function () {
    var input = document.querySelector('input[type=file]');
    var file = input.files[0];
    alert('s');
    var fileReader = new FileReader(),
      slice = file.slice(0, 20000);
    fileReader.readAsArrayBuffer(slice);
    fileReader.onload = (evt) => {
      var arrayBuffer = fileReader.result;
      console.log({
        name: file.name,
        type: file.type,
        size: file.size,
        data: arrayBuffer
      });
      socket.emit('slice upload', {
        name: file.name,
        type: file.type,
        size: file.size,
        data: arrayBuffer
      });
    }
  })

  $gotoroom.click(function () {
    setUsername();
  });

  $onlineer.change(function () {
    if ($onlineer.val() == '1') {
      socket.emit('join ready', {
        token: token
      })
    } else {
      socket.emit('leave ready', {
        token: token
      })
    }
  })

  $window.keydown(event => {
    // Auto-focus the current input when a key is typed
    if (!(event.ctrlKey || event.metaKey || event.altKey)) {
      $currentInput.focus();
    }
    // When the client hits ENTER on their keyboard
    if (event.which === 13) {
      if (username) {
        sendMessage();
        socket.emit('stop typing');
        typing = false;
      } else {
        setUsername();
      }
    }
  });


  $clienthomevisit.click(function () {
    getLocation();

    alert(JSON.stringify(publicgps));

    if (publicgps != null) {
      socket.emit('clienthomevisit', publicgps);
    }

  })

  $inputMessage.on('input', () => {
    updateTyping();
  });

  // Click events

  // Focus input when clicking anywhere on login page
  $loginPage.click(() => {
    $currentInput.focus();
  });

  // Focus input when clicking on the message input's border
  $inputMessage.click(() => {
    $inputMessage.focus();
  });

  // Socket events

  // Whenever the server emits 'login', log the login message
  socket.on('login', (data) => {
    connected = true;
    // Display the welcome message
    var message = "به چت روم طبیب خوش آمدید";
    log(message, {
      prepend: true
    });
    addParticipantsMessage(data);
  });


  socket.on('end upload',(data)=>{
    $('.upload-prescription,.file').css('display','');
    $('#progress').css('display','none');

  })

  //continue upload file;
  socket.on('request slice upload',(data)=>{
    $('.upload-prescription,.file').css('display','none');

    $('#progress').css('display','');
    $('#progress').attr('value',data.currentSlice);
    

    console.log(data);
    // alert(data.currentSlice);
    var input = document.querySelector('input[type=file]');
    var file = input.files[0];
    $('#progress').attr('max',file.size/20000);
    // alert('s');
    var fileReader = new FileReader(),
      slice = file.slice(data.currentSlice*20000, (data.currentSlice*20000)+20000);

      
    fileReader.readAsArrayBuffer(slice);
    fileReader.onload = (evt) => {
      var arrayBuffer = fileReader.result;
      console.log({
        name: file.name,
        type: file.type,
        size: file.size,
        data: arrayBuffer
      });
      socket.emit('slice upload', {
        name: file.name,
        type: file.type,
        size: file.size,
        data: arrayBuffer
      });
    }
  })

  // Whenever the server emits 'new message', update the chat body
  socket.on('new message', (data) => {
    addChatMessage(data);
  });

  socket.on('clienthomevisit', (data) => {
    console.log(data);
    if (window.confirm(data.message.description + '\r\n' + data.message.price + 'تومان' + '\r\n' + 'latitude:' + data.message.latitude + 'longitude:' + data.message.longitude)) {
      socket.emit('accept', { request_id: data.request_id, token: token });
    }
  });

  socket.on('clienthealthcertificate', (data) => {
    console.log(data);
    if (window.confirm(data.message.description + '\r\n' + data.message.price + 'تومان' + '\r\n' + 'latitude:' + data.message.latitude + 'longitude:' + data.message.longitude)) {
      socket.emit('accept', { request_id: data.request_id, token: token });
    }
  });

  socket.on('clientdeathcertificate', (data) => {
    console.log(data);
    if (window.confirm(data.message.description + '\r\n' + data.message.price + 'تومان' + '\r\n' + 'latitude:' + data.message.latitude + 'longitude:' + data.message.longitude)) {
      socket.emit('accept', { request_id: data.request_id, token: token });
    }
  });

  // Whenever the server emits 'user joined', log it in the chat body
  socket.on('user joined', (data) => {
    log(data.username + ' به اتاق پیوست');
    addParticipantsMessage(data);
  });

  // Whenever the server emits 'user left', log it in the chat body
  socket.on('user left', (data) => {
    log(data.username + ' خارج شد');
    addParticipantsMessage(data);
    removeChatTyping(data);
  });

  // Whenever the server emits 'typing', show the typing message
  socket.on('typing', (data) => {
    addChatTyping(data);
  });

  // Whenever the server emits 'stop typing', kill the typing message
  socket.on('stop typing', (data) => {
    removeChatTyping(data);
  });

  socket.on('disconnect', () => {
    log('ارتباط شما قطع شد');
  });

  socket.on('reconnect', () => {
    log('شما مجددا وصل شدید');
    if (username) {
      socket.emit('add therapist', { token: token });
    }
  });

  socket.on('reconnect_error', () => {
    log('attempt to reconnect has failed');
  });

});
