const Route = use('Route')

Route.group(() => {
    Route.get('/login', 'Admin/AuthController.login');
    Route.post('/login', 'Admin/AuthController.checklogin');

    Route.get('/', 'Admin/HomeController.index');

    Route.get('/auth/logout', 'Admin/AuthController.logout');

    Route.get('/auth/users', 'Admin/AdminUserController.index');
    Route.get('/auth/users/create', 'Admin/AdminUserController.create');
    Route.post('/auth/users/create', 'Admin/AdminUserController.store');
    Route.get('/auth/users/edit/:id', 'Admin/AdminUserController.show');
    Route.post('/auth/users/edit/:id', 'Admin/AdminUserController.update');
    Route.get('/auth/users/remove/:id', 'Admin/AdminUserController.remove');


    Route.get('/admin_operation_logs','Admin/AdminOperationLogController.index');
    Route.get('/admin_operation_logs/create','Admin/AdminOperationLogController.create');
    Route.post('/admin_operation_logs/create','Admin/AdminOperationLogController.store');
    Route.get('/admin_operation_logs/edit/:id','Admin/AdminOperationLogController.show');
    Route.post('/admin_operation_logs/edit/:id','Admin/AdminOperationLogController.update');
    Route.get('/admin_operation_logs/remove/:id','Admin/AdminOperationLogController.remove');


    Route.get('/auth/menu', 'Admin/AdminMenuController.index');
    Route.get('/auth/menu/create', 'Admin/AdminMenuController.create');
    Route.post('/auth/menu/create', 'Admin/AdminMenuController.store');
    Route.get('/auth/menu/edit/:id', 'Admin/AdminMenuController.show');
    Route.post('/auth/menu/edit/:id', 'Admin/AdminMenuController.update');
    Route.get('/auth/menu/remove/:id', 'Admin/AdminMenuController.remove');


    Route.get('/admin_permissions','Admin/AdminPermissionController.index');
    Route.get('/admin_permissions/create','Admin/AdminPermissionController.create');
    Route.post('/admin_permissions/create','Admin/AdminPermissionController.store');
    Route.get('/admin_permissions/edit/:id','Admin/AdminPermissionController.show');
    Route.post('/admin_permissions/edit/:id','Admin/AdminPermissionController.update');
    Route.get('/admin_permissions/remove/:id','Admin/AdminPermissionController.remove');


    
    Route.get('/admin_roles','Admin/AdminRoleController.index');
    Route.get('/admin_roles/create','Admin/AdminRoleController.create');
    Route.post('/admin_roles/create','Admin/AdminRoleController.store');
    Route.get('/admin_roles/edit/:id','Admin/AdminRoleController.show');
    Route.post('/admin_roles/edit/:id','Admin/AdminRoleController.update');
    Route.get('/admin_roles/remove/:id','Admin/AdminRoleController.remove');


    Route.get('/admin_role_menus','Admin/AdminRoleMenuController.index');
    Route.get('/admin_role_menus/create','Admin/AdminRoleMenuController.create');
    Route.post('/admin_role_menus/create','Admin/AdminRoleMenuController.store');
    Route.get('/admin_role_menus/edit/:id','Admin/AdminRoleMenuController.show');
    Route.post('/admin_role_menus/edit/:id','Admin/AdminRoleMenuController.update');
    Route.get('/admin_role_menus/remove/:id','Admin/AdminRoleMenuController.remove');


    Route.get('/admin_role_users','Admin/AdminRoleUserController.index');
    Route.get('/admin_role_users/create','Admin/AdminRoleUserController.create');
    Route.post('/admin_role_users/create','Admin/AdminRoleUserController.store');
    Route.get('/admin_role_users/edit/:id','Admin/AdminRoleUserController.show');
    Route.post('/admin_role_users/edit/:id','Admin/AdminRoleUserController.update');
    Route.get('/admin_role_users/remove/:id','Admin/AdminRoleUserController.remove');


    Route.get('/admin_role_permissions','Admin/AdminRolePermissionController.index');
    Route.get('/admin_role_permissions/create','Admin/AdminRolePermissionController.create');
    Route.post('/admin_role_permissions/create','Admin/AdminRolePermissionController.store');
    Route.get('/admin_role_permissions/edit/:id','Admin/AdminRolePermissionController.show');
    Route.post('/admin_role_permissions/edit/:id','Admin/AdminRolePermissionController.update');
    Route.get('/admin_role_permissions/remove/:id','Admin/AdminRolePermissionController.remove');

    




    Route.get('/doctors', 'Admin/doctorController.index');
    Route.get('/doctors/create', 'Admin/doctorController.create');
    Route.post('/doctors/create', 'Admin/doctorController.store');
    Route.get('/doctors/edit/:id', 'Admin/doctorController.show');
    Route.post('/doctors/edit/:id', 'Admin/doctorController.update');
    Route.get('/doctors/remove/:id', 'Admin/doctorController.remove');

    Route.get('/doctors/history/:mobile','Admin/doctorController.history');



    Route.get('/Comments', 'Admin/CommentController.index');
    Route.get('/Comments/create', 'Admin/CommentController.create');
    Route.post('/Comments/create', 'Admin/CommentController.store');
    Route.get('/Comments/edit/:id', 'Admin/CommentController.show');
    Route.post('/Comments/edit/:id', 'Admin/CommentController.update');
    Route.get('/Comments/remove/:id', 'Admin/CommentController.remove');


    Route.get('/Drugstores', 'Admin/DrugstoreController.index');
    Route.get('/Drugstores/create', 'Admin/DrugstoreController.create');
    Route.post('/Drugstores/create', 'Admin/DrugstoreController.store');
    Route.get('/Drugstores/edit/:id', 'Admin/DrugstoreController.show');
    Route.post('/Drugstores/edit/:id', 'Admin/DrugstoreController.update');
    Route.get('/Drugstores/remove/:id', 'Admin/DrugstoreController.remove');


    Route.get('/Favorites', 'Admin/FavoriteController.index');
    Route.get('/Favorites/create', 'Admin/FavoriteController.create');
    Route.post('/Favorites/create', 'Admin/FavoriteController.store');
    Route.get('/Favorites/edit/:id', 'Admin/FavoriteController.show');
    Route.post('/Favorites/edit/:id', 'Admin/FavoriteController.update');
    Route.get('/Favorites/remove/:id', 'Admin/FavoriteController.remove');


    Route.get('/Feedbacks', 'Admin/FeedbackController.index');
    Route.get('/Feedbacks/create', 'Admin/FeedbackController.create');
    Route.post('/Feedbacks/create', 'Admin/FeedbackController.store');
    Route.get('/Feedbacks/edit/:id', 'Admin/FeedbackController.show');
    Route.post('/Feedbacks/edit/:id', 'Admin/FeedbackController.update');
    Route.get('/Feedbacks/remove/:id', 'Admin/FeedbackController.remove');


    Route.get('/Insurances', 'Admin/InsuranceController.index');
    Route.get('/Insurances/create', 'Admin/InsuranceController.create');
    Route.post('/Insurances/create', 'Admin/InsuranceController.store');
    Route.get('/Insurances/edit/:id', 'Admin/InsuranceController.show');
    Route.post('/Insurances/edit/:id', 'Admin/InsuranceController.update');
    Route.get('/Insurances/remove/:id', 'Admin/InsuranceController.remove');



    Route.get('/Laboratories', 'Admin/LaboratoryController.index');
    Route.get('/Laboratories/create', 'Admin/LaboratoryController.create');
    Route.post('/Laboratories/create', 'Admin/LaboratoryController.store');
    Route.get('/Laboratories/edit/:id', 'Admin/LaboratoryController.show');
    Route.post('/Laboratories/edit/:id', 'Admin/LaboratoryController.update');
    Route.get('/Laboratories/remove/:id', 'Admin/LaboratoryController.remove');


    Route.get('/Logs', 'Admin/LogController.index');
    Route.get('/Logs/create', 'Admin/LogController.create');
    Route.post('/Logs/create', 'Admin/LogController.store');
    Route.get('/Logs/edit/:id', 'Admin/LogController.show');
    Route.post('/Logs/edit/:id', 'Admin/LogController.update');
    Route.get('/Logs/remove/:id', 'Admin/LogController.remove');



    Route.get('/News', 'Admin/NewsController.index');
    Route.get('/News/create', 'Admin/NewsController.create');
    Route.post('/News/create', 'Admin/NewsController.store');
    Route.get('/News/edit/:id', 'Admin/NewsController.show');
    Route.post('/News/edit/:id', 'Admin/NewsController.update');
    Route.get('/News/remove/:id', 'Admin/NewsController.remove');


    Route.get('/Nurses', 'Admin/NurseController.index');
    Route.get('/Nurses/create', 'Admin/NurseController.create');
    Route.post('/Nurses/create', 'Admin/NurseController.store');
    Route.get('/Nurses/edit/:id', 'Admin/NurseController.show');
    Route.post('/Nurses/edit/:id', 'Admin/NurseController.update');
    Route.get('/Nurses/remove/:id', 'Admin/NurseController.remove');

    Route.get('/service_pricings', 'Admin/ServicePricingController.index');
    Route.get('/service_pricings/create', 'Admin/ServicePricingController.create');
    Route.post('/service_pricings/create', 'Admin/ServicePricingController.store');
    Route.get('/service_pricings/edit/:id', 'Admin/ServicePricingController.show');
    Route.post('/service_pricings/edit/:id', 'Admin/ServicePricingController.update');
    Route.get('/service_pricings/remove/:id', 'Admin/ServicePricingController.remove');


    Route.get('/supports', 'Admin/SupportController.index');
    Route.get('/supports/create', 'Admin/SupportController.create');
    Route.post('/supports/create', 'Admin/SupportController.store');
    Route.get('/supports/edit/:id', 'Admin/SupportController.show');
    Route.post('/supports/edit/:id', 'Admin/SupportController.update');
    Route.get('/supports/remove/:id', 'Admin/SupportController.remove');


    Route.get('/therapists', 'Admin/TherapistController.index');
    Route.get('/therapists/create', 'Admin/TherapistController.create');
    Route.post('/therapists/create', 'Admin/TherapistController.store');
    Route.get('/therapists/edit/:id', 'Admin/TherapistController.show');
    Route.post('/therapists/edit/:id', 'Admin/TherapistController.update');
    Route.get('/therapists/remove/:id', 'Admin/TherapistController.remove');


    Route.get('/therapist_wallets', 'Admin/TherapistWalletController.index');
    Route.get('/therapist_wallets/create', 'Admin/TherapistWalletController.create');
    Route.post('/therapist_wallets/create', 'Admin/TherapistWalletController.store');
    Route.get('/therapist_wallets/edit/:id', 'Admin/TherapistWalletController.show');
    Route.post('/therapist_wallets/edit/:id', 'Admin/TherapistWalletController.update');
    Route.get('/therapist_wallets/remove/:id', 'Admin/TherapistWalletController.remove');

    Route.get('/user_messages', 'Admin/UserMessageController.index');
    Route.get('/user_messages/create', 'Admin/UserMessageController.create');
    Route.post('/user_messages/create', 'Admin/UserMessageController.store');
    Route.get('/user_messages/edit/:id', 'Admin/UserMessageController.show');
    Route.post('/user_messages/edit/:id', 'Admin/UserMessageController.update');
    Route.get('/user_messages/remove/:id', 'Admin/UserMessageController.remove');

    Route.get('/user_addresses', 'Admin/UserAddressController.index');
    Route.get('/user_addresses/create', 'Admin/UserAddressController.create');
    Route.post('/user_addresses/create', 'Admin/UserAddressController.store');
    Route.get('/user_addresses/edit/:id', 'Admin/UserAddressController.show');
    Route.post('/user_addresses/edit/:id', 'Admin/UserAddressController.update');
    Route.get('/user_addresses/remove/:id', 'Admin/UserAddressController.remove');


    Route.get('/transactions', 'Admin/TransactionController.index');
    Route.get('/transactions/create', 'Admin/TransactionController.create');
    Route.post('/transactions/create', 'Admin/TransactionController.store');
    Route.get('/transactions/edit/:id', 'Admin/TransactionController.show');
    Route.post('/transactions/edit/:id', 'Admin/TransactionController.update');
    Route.get('/transactions/remove/:id', 'Admin/TransactionController.remove');


    Route.get('/user_wallets', 'Admin/UserWalletController.index');
    Route.get('/user_wallets/create', 'Admin/UserWalletController.create');
    Route.post('/user_wallets/create', 'Admin/UserWalletController.store');
    Route.get('/user_wallets/edit/:id', 'Admin/UserWalletController.show');
    Route.post('/user_wallets/edit/:id', 'Admin/UserWalletController.update');
    Route.get('/user_wallets/remove/:id', 'Admin/UserWalletController.remove');
    Route.get('/users', 'Admin/UserController.index');


    Route.get('/prescriptions','Admin/PrescriptionController.index');
    Route.get('/prescriptions/create','Admin/PrescriptionController.create');    
    Route.post('/prescriptions/create','Admin/PrescriptionController.store');    
    Route.get('/prescriptions/edit/:id','Admin/PrescriptionController.show');    
    Route.post('/prescriptions/edit/:id','Admin/PrescriptionController.update'); 
    Route.get('/prescriptions/remove/:id','Admin/PrescriptionController.remove');

    Route.get('/laboratory_instructions','Admin/LaboratoryInstructionController.index');
    Route.get('/laboratory_instructions/create','Admin/LaboratoryInstructionController.create');
    Route.post('/laboratory_instructions/create','Admin/LaboratoryInstructionController.store');
    Route.get('/laboratory_instructions/edit/:id','Admin/LaboratoryInstructionController.show');
    Route.post('/laboratory_instructions/edit/:id','Admin/LaboratoryInstructionController.update');
    Route.get('/laboratory_instructions/remove/:id','Admin/LaboratoryInstructionController.remove');


    Route.get('/configs','Admin/ConfigController.index');
    Route.get('/configs/create','Admin/ConfigController.create');
    Route.post('/configs/create','Admin/ConfigController.store');
    Route.get('/configs/edit/:id','Admin/ConfigController.show');
    Route.post('/configs/edit/:id','Admin/ConfigController.update');
    Route.get('/configs/remove/:id','Admin/ConfigController.remove');



    
    Route.get('/service_categories','Admin/ServiceCategoryController.index');
    Route.get('/service_categories/create','Admin/ServiceCategoryController.create');
    Route.post('/service_categories/create','Admin/ServiceCategoryController.store');
    Route.get('/service_categories/edit/:id','Admin/ServiceCategoryController.show');
    Route.post('/service_categories/edit/:id','Admin/ServiceCategoryController.update');
    Route.get('/service_categories/remove/:id','Admin/ServiceCategoryController.remove');


    
    
    Route.get('/auth/setting','Admin/AuthController.changePassword');
    Route.post('/auth/setting','Admin/AuthController.updatepassword');



    Route.get('/midwife', 'Admin/MidwifeController.index');
    Route.get('/midwife/create', 'Admin/MidwifeController.create');
    Route.post('/midwife/create', 'Admin/MidwifeController.store');
    Route.get('/midwife/edit/:id', 'Admin/MidwifeController.show');
    Route.post('/midwife/edit/:id', 'Admin/MidwifeController.update');
    Route.get('/midwife/remove/:id', 'Admin/MidwifeController.remove');


    Route.get('/sampling_sans','Admin/SamplingSansController.index');
    Route.get('/sampling_sans/create','Admin/SamplingSansController.create');
    Route.post('/sampling_sans/create','Admin/SamplingSansController.store');
    Route.get('/sampling_sans/edit/:id','Admin/SamplingSansController.show');
    Route.post('/sampling_sans/edit/:id','Admin/SamplingSansController.update');
    Route.get('/sampling_sans/remove/:id','Admin/SamplingSansController.remove');


    Route.get('/holy_days','Admin/HolyDayController.index');
    Route.get('/holy_days/create','Admin/HolyDayController.create');
    Route.post('/holy_days/create','Admin/HolyDayController.store');
    Route.get('/holy_days/edit/:id','Admin/HolyDayController.show');
    Route.post('/holy_days/edit/:id','Admin/HolyDayController.update');
    Route.get('/holy_days/remove/:id','Admin/HolyDayController.remove');


    Route.get('/banners','Admin/BannerController.index');
    Route.get('/banners/create','Admin/BannerController.create');
    Route.post('/banners/create','Admin/BannerController.store');
    Route.get('/banners/edit/:id','Admin/BannerController.show');
    Route.post('/banners/edit/:id','Admin/BannerController.update');
    Route.get('/banners/remove/:id','Admin/BannerController.remove');


    Route.get('/categories','Admin/CategoryController.index');
    Route.get('/categories/create','Admin/CategoryController.create');
    Route.post('/categories/create','Admin/CategoryController.store');
    Route.get('/categories/edit/:id','Admin/CategoryController.show');
    Route.post('/categories/edit/:id','Admin/CategoryController.update');
    Route.get('/categories/remove/:id','Admin/CategoryController.remove');


    Route.get('/products','Admin/ProductController.index');
    Route.get('/products/create','Admin/ProductController.create');
    Route.post('/products/create','Admin/ProductController.store');
    Route.get('/products/edit/:id','Admin/ProductController.show');
    Route.post('/products/edit/:id','Admin/ProductController.update');
    Route.get('/products/remove/:id','Admin/ProductController.remove');


    Route.get('/therapist_deposits','Admin/TherapistDepositController.index');
    Route.get('/therapist_deposits/create','Admin/TherapistDepositController.create');
    Route.post('/therapist_deposits/create','Admin/TherapistDepositController.store');
    Route.get('/therapist_deposits/edit/:id','Admin/TherapistDepositController.show');
    Route.post('/therapist_deposits/edit/:id','Admin/TherapistDepositController.update');
    Route.get('/therapist_deposits/remove/:id','Admin/TherapistDepositController.remove');


    Route.get('/pages','Admin/PageContoller.index');
    Route.get('/pages/create','Admin/PageContoller.create');
    Route.post('/pages/create','Admin/PageContoller.store');
    Route.get('/pages/edit/:id','Admin/PageContoller.show');
    Route.post('/pages/edit/:id','Admin/PageContoller.update');
    Route.get('/pages/remove/:id','Admin/PageContoller.remove');


    Route.get('/active_areas','Admin/ActiveAreaController.index');
    Route.get('/active_areas/create','Admin/ActiveAreaController.create');
    Route.post('/active_areas/create','Admin/ActiveAreaController.store');
    Route.get('/active_areas/edit/:id','Admin/ActiveAreaController.show');
    Route.post('/active_areas/edit/:id','Admin/ActiveAreaController.update');
    Route.get('/active_areas/remove/:id','Admin/ActiveAreaController.remove');

    Route.get('/requests','Admin/RequestController.index');
    Route.get('/requests/edit/:id','Admin/RequestController.show');
    Route.post('/requests/edit/:id','Admin/RequestController.update');
    



}).prefix('admin').middleware(['admin','adminlog']);


Route.get('/',function({request,response}){
    if(request.hostname()=="tabibashi.com"){
        return    response.redirect('/admin');
    }else{
        if(request.hostname()=='localhost'){
            
            
            return '<script>if(location.hostname=="laboratories.tabibashi.com"){location="http://www.laboratories.tabibashi.com:3333/laboratories"};if(location.hostname=="pharmacies.tabibashi.com"){location="http://www.pharmacies.tabibashi.com:3333/drugstore"}; if(location.hostname=="supercms.tabibashi.com"){location="http://www.supercms.tabibashi.com:3333/admin"};if(location.hostname=="www.laboratories.tabibashi.com"){location="http://www.laboratories.tabibashi.com:3333/laboratories"};if(location.hostname=="www.pharmacies.tabibashi.com"){location="http://www.pharmacies.tabibashi.com:3333/drugstore"}; if(location.hostname=="www.supercms.tabibashi.com"){location="http://www.supercms.tabibashi.com:3333/admin"}</script>'
        }

    }

})