const Route = use('Route');
const UserAddress = use('App/Models/UserAddress');
Route.group(() => {
    Route.get('/ping', function () {
        return { data: 'pong' };
    });
    Route.get('/pages','HomeController.showPages');
    Route.post('/user/login', 'AuthController.login');
    Route.post('/user/verify', 'AuthController.verify');
    Route.get('/user/charge/callback/:id','UserController.callbackCharge');
    Route.get('/orders/callback/:id','UserController.callbackOrders');
    
    Route.get('/configs','UserController.showConfig');
    Route.get('/service_pricing/laboratory','UserLabController.showPriceLab');
    Route.get('/service_pricing/nurse','UserNurseController.showPriceNurse');
    Route.get('/service_pricing/midwife','UserMidwifeController.showPriceMidwife');
    Route.get('/service_pricing/doctor','HomeController.showDoctorVisitPrice');
    Route.get('/insurances','UserController.showInsurance');

    Route.get('/last/version',function(){
        return {
            version_number:1,
            version_link:'http://aloapp.app',
        }
    });

    // Route.get('/send/fcm','UserController.sendCloudMessage');
}).prefix('api/v1/client')


Route.group(()=>{
    Route.post('/user/charge/wallet','UserController.charge');
    Route.post('/user/address','UserController.saveAddress');
    Route.post('/user/shop/address','UserController.saveShopAddress');

    Route.get('user/shop/address','UserController.ShowShopAddress');
    

    Route.post('/user/firebase','UserController.saveTokenFirebase');

    

    
    Route.get('/user/address/:id','UserController.removeAddressTitle');
    Route.post('/user/list/address','UserController.showAddress');
    Route.get('/user/info','UserController.showInfo');
    Route.put('/user/info','UserController.updateInfo');
    Route.get('/nurse/service/price/list','NurseServiceController.showPrices');
    Route.post('/feedbacks','FeedbackController.save');
    Route.get('/checkfeedback','FeedbackController.shownofeedback');
    Route.post('/support','FeedbackController.saveSupport');
    Route.get('/messages','UserController.showMessage');
    Route.get('/transactions','UserWalletManagerController.showWallet');
    Route.get('/balance','UserWalletManagerController.showBalance');
    Route.get('/banners','HomeController.showBanner');
    Route.get('/news','HomeController.showNews');
    Route.get('/shop/categories','HomeController.showCategories');
    Route.get('/shop/products','HomeController.showProducts');
    Route.get('/user/request/current','HistoryRequestController.showCurrent');
    Route.get('/user/request/record','HistoryRequestController.showRecord');

    Route.post('/orders','UserController.saveOrders');
    Route.get('/orders','UserController.showOrders');

    Route.get('/business/days','BusinessController.showDays');
    Route.get('/business/sans','BusinessController.showSans');
    

    Route.post('/user/avatar','UserController.saveAvatar');

    Route.get('/active/area','BusinessController.showActiveArea');

    Route.post('/payemnt/:id','UserWalletManagerController.rePayemnt');



    
    

}).prefix('api/v1/client').middleware(['client']);



Route.group(()=>{
    Route.get('/client/room/:token',async ({request,view,params})=>{
        var useraddress= await UserAddress.query().where('user_id','=',request.user.id).fetch();
        // return {...request.therapist}.id;
        return view.render('client',{...request.user,token:params.token,useraddress:useraddress.toJSON()});
    })
}).middleware(['client']);
