const Route = use('Route');
const CaptchaController = use('App/Controllers/Http/CaptchaController');
const Drugstore = use('App/Models/Drugstore');
const sha1 = require('js-sha1');
const persianjs = require('persianjs');
const Cryptr = require('cryptr');
const cryptr = new Cryptr('mahjava');
const Prescription = use('App/Models/Prescription');
const TherapistWallet = use ('App/Models/TherapistWallet');

Route.group(() => {

    Route.get('/', async ({ request, session, response, view }) => {

        // return response.send(persianjs("5558885250005").digitsToWords()._str)
        if (session.get('drugstoreusername') != null) {
            //.where('therapist_drogstore_id','=',session.get('drugstoreusername')).where('status','=','accept')
            var ps = await Prescription.query().whereIn('status', ['accept', 'unpaid', 'paid']).where('therapist_drogstore_id', '=', session.get('drugstoreusername')).with('address').with('user').orderBy('updated_at', 'desc').fetch();
            console.clear();
            console.log("=================== 20 =================")
            console.log(ps.toJSON());
            console.log(ps);

            return view.render('drugstore.index', { token: session.get('token'), prescriptions: ps.toJSON() });
        } else {

            return response.redirect('/drugstore/login')

        }
    });

    Route.get('/wallet', async ({ request, session, response, view }) => {
        if (session.get('drugstoreusername') != null) {
            var ds=await Drugstore.find(session.get('drugstoreusername'));

            var wallet=await TherapistWallet.query().where('therapist_id','=',ds.therapist_id).fetch();

            return view.render('drugstore.wallet', { token: session.get('token'),wallets:wallet.toJSON() });

        } else {

            return response.redirect('/drugstore/login')

        }
    })

    Route.get('/history', async ({ request, session, response, view }) => {
        var ps = await Prescription.query().whereIn('status', ['deliver']).where('therapist_drogstore_id', '=', session.get('drugstoreusername')).with('address').orderBy('updated_at', 'desc').fetch();

        if (session.get('drugstoreusername') != null) {
            return view.render('drugstore.history', { token: session.get('token'),history:ps.toJSON() });
        } else {

            return response.redirect('/drugstore/login')

        }
    });

    Route.get('/logout', async ({ request, session, response, view }) => {
        session.forget('drugstoreusername');
        return response.redirect('/drugstore/login')
    });



    Route.get('/login', async ({ view, session }) => {
        var c = new CaptchaController();
        // return c.captcha;

        session.put('captcha1', c.captcha.text);


        return view.render('drugstore.login', { captcha: c.captcha.image });
    });

    Route.post('/login', async ({ view, request, session, response }) => {

        if (session.get('captcha1') == request.input('captcha')) {
            var user = await Drugstore.query().where('mobile', '=', request.input('usermobile')).first();



            var pass = sha1(request.input('uminpass'));

            if (user.password == pass) {
                session.put('drugstoreusername', user.id);
                session.put('token', user.mobile + '==' + cryptr.encrypt(user.password));

                return response.redirect('/drugstore/')
            } else {
                return response.redirect('/drugstore/login')
            }




            return user.toJSON();
        } else {
            return response.send(session.get('captcha1'));
        }





    })

}).prefix('drugstore');