const Route = use('Route');
const CaptchaController = use('App/Controllers/Http/CaptchaController');
const Laboratory = use('App/Models/Laboratory');
const sha1 = require('js-sha1');
const persianjs = require('persianjs');
const Cryptr = require('cryptr');
const { json } = require('server/reply');
const cryptr = new Cryptr('mahjava');
const LaboratoryInstruction = use('App/Models/LaboratoryInstruction');
const TherapistWallet = use ('App/Models/TherapistWallet');
const ServicePricing=use ('App/Models/ServicePricing');
const ServiceCategory =use ('App/Models/ServiceCategory');
const SamplingSan= use('App/Models/SamplingSan');

Route.group(() => {

    Route.get('/', async ({ request, session, response, view }) => {

        // return response.send(persianjs("5558885250005").digitsToWords()._str)
        if (session.get('laboratoryusername') != null) {
            //.where('therapist_drogstore_id','=',session.get('laboratoryusername')).where('status','=','accept')
            var ps = await LaboratoryInstruction.query().whereIn('status', ['accept', 'unpaid', 'paid','sampling','test']).where('therapist_laboratory_id', '=', session.get('laboratoryusername')).with('address').with('user').orderBy('updated_at', 'desc').fetch();
            console.clear();
            console.log("=================== 20 =================")
            console.log(ps.toJSON());
            console.log(ps);

            var sc=await ServiceCategory.query().where('type','=','laboratory').fetch();
          

            sc= sc.toJSON();

            var scid=[];

            sc.forEach(element => {
              scid.push(element.id);
            });

            


            var listextra=await ServicePricing.query().whereIn('category_id',scid).fetch();

            var sans=await SamplingSan.query().fetch();

           
            var listextrajson=listextra.toJSON();
           

            return view.render('laboratory.index', { token: session.get('token'), prescriptions: ps.toJSON(),listextra:listextra.toJSON(),sans:sans.toJSON(), makeextra:function(pn,extralist){
                var end=[];
                extralist.forEach(function(e){
                    if(JSON.parse(pn.extra).includes(e.id)){
                        end.push('<li>'+e.title+'</li>');
                    }
                })
                return end.join("");
                } ,
                filter:function(json,sans_id){
                   
                    return json.filter(f=>f.id==sans_id)[0].start+' تا  '+json.filter(f=>f.id==sans_id)[0].end;
                }
                }
                ,);
        } else {

            return response.redirect('/laboratories/login')

        }
    });

    Route.get('/wallet', async ({ request, session, response, view }) => {
        if (session.get('laboratoryusername') != null) {
            var ds=await Laboratory.find(session.get('laboratoryusername'));

            var wallet=await TherapistWallet.query().where('therapist_id','=',ds.therapist_id).fetch();

            return view.render('laboratory.wallet', { token: session.get('token'),wallets:wallet.toJSON() });

        } else {

            return response.redirect('/laboratories/login')

        }
    })


    Route.get('/pricing', async ({ request, session, response, view }) => {
        if (session.get('laboratoryusername') != null) {
            var ds=await Laboratory.find(session.get('laboratoryusername'));

            var sc=await ServiceCategory.query().where('type','=','laboratory').fetch();
          

            sc= sc.toJSON();

            var scid=[];

            sc.forEach(element => {
              scid.push(element.id);
            });

            


            var sp=await ServicePricing.query().whereIn('category_id',scid).fetch();

            return view.render('laboratory.pricing', { token: session.get('token'),servicePricing:sp.toJSON() });

        } else {

            return response.redirect('/laboratories/login')

        }
    })

    Route.get('/history', async ({ request, session, response, view }) => {
        var ps = await LaboratoryInstruction.query().whereIn('status', ['deliver']).where('therapist_laboratory_id', '=', session.get('laboratoryusername')).with('address').orderBy('updated_at', 'desc').fetch();

        if (session.get('laboratoryusername') != null) {
            return view.render('laboratory.history', { token: session.get('token'),history:ps.toJSON() });
        } else {

            return response.redirect('/laboratories/login')

        }
    });

    Route.get('/logout', async ({ request, session, response, view }) => {
        session.forget('laboratoryusername');
        return response.redirect('/laboratories/login')
    });



    Route.get('/login', async ({ view, session }) => {
        var c = new CaptchaController();
        // return c.captcha;

        session.put('captcha1', c.captcha.text);


        return view.render('laboratory.login', { captcha: c.captcha.image });
    });

    Route.post('/login', async ({ view, request, session, response }) => {

        if (session.get('captcha1') == request.input('captcha')) {
            var user = await Laboratory.query().where('mobile', '=', request.input('usermobile')).first();



            var pass = sha1(request.input('uminpass'));

            if (user.password == pass) {
                session.put('laboratoryusername', user.id);
                session.put('token', user.mobile + '==' + cryptr.encrypt(user.password));

                return response.redirect('/laboratories/')
            } else {
                return response.redirect('/laboratories/login')
            }




            return user.toJSON();
        } else {
            return response.send(session.get('captcha1'));
        }





    })

}).prefix('laboratories');