const Route = use('Route')
Route.group(() => {

    Route.get('/ping', function () {
        return { data: 'pong' };
    })

    Route.post('/login','Therapist/AuthController.login')
    Route.post('/verify', 'Therapist/AuthController.verify');

    Route.get('/configs','UserController.showConfig');

  
}).prefix('api/v1/therapist')


Route.group(()=>{
    Route.get('/therapist/room/:token',({request,view,params})=>{

        
        

        // return {...request.therapist}.id;
        return view.render('therapist',{...request.therapist,token:params.token});
    })
}).middleware(['therapist']);

Route.group(()=>{
    Route.get('/user/request/current','HistoryRequestController.showTherapistCurrent');
    Route.get('/user/request/record','HistoryRequestController.showTherapistRecord');
    Route.get('/transactions','TherapistWalletManagerController.showWallet');
    Route.get('/balance','TherapistWalletManagerController.showBalance');
    Route.post('/deposit','TherapistWalletManagerController.saveDeposit');

    Route.get('/info','Therapist/InfoController.showInfo');

   
    
}).prefix('api/v1/therapist').middleware(['therapist']);;

